/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports.converters;

import com.relevantcodes.extentreports.ExtentReports;
import com.relevantcodes.extentreports.ExtentTest;
import com.relevantcodes.extentreports.LogSettings;
import com.relevantcodes.extentreports.converters.ChildTestConverter;
import com.relevantcodes.extentreports.converters.LogConverter;
import com.relevantcodes.extentreports.model.Log;
import com.relevantcodes.extentreports.model.Test;
import com.relevantcodes.extentreports.utils.DateTimeUtil;
import com.relevantcodes.extentreports.utils.FileReaderEx;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class TestConverter
extends LogSettings {
    private static final Logger logger = Logger.getLogger(TestConverter.class.getName());
    private Document doc;
    private File file;
    private ExtentReports extent;

    public void createTestList() {
        Elements body = this.doc.select("body.extent");
        if (body == null || body.size() == 0) {
            logger.log(Level.SEVERE, "The supplied file " + this.file.getAbsolutePath() + " is not a valid Extent file. " + "Unable to parse file to extra test contents.");
            return;
        }
        Elements allTests = this.doc.select(".test");
        for (Element test : allTests) {
            ChildTestConverter nodeConverter;
            List<Test> nodeList;
            Object category2;
            String name = test.select(".test-name").first().text().trim();
            String description = test.select(".test-desc").first().text().trim();
            ExtentTest extentTest = this.extent.startTest(name, description);
            extentTest.getTest().setStartedTime(DateTimeUtil.getDate(test.select(".test-started-time").first().text(), LogSettings.getLogDateTimeFormat()));
            extentTest.getTest().setEndedTime(DateTimeUtil.getDate(test.select(".test-ended-time").first().text(), LogSettings.getLogDateTimeFormat()));
            Elements categories = test.select(".category");
            for (Object category2 : categories) {
                extentTest.assignCategory(category2.text());
            }
            Elements authors = test.select(".author");
            category2 = authors.iterator();
            while (category2.hasNext()) {
                Element author = (Element)category2.next();
                extentTest.assignAuthor(author.text());
            }
            LogConverter logConverter = new LogConverter(test);
            List<Log> logList = logConverter.getLogList();
            if (logList != null && logList.size() > 0) {
                extentTest.getTest().setLog(logList);
            }
            if ((nodeList = (nodeConverter = new ChildTestConverter(test)).getNodeList()) != null && nodeList.size() > 0) {
                extentTest.getTest().hasChildNodes = true;
                extentTest.getTest().setNodeList(nodeList);
            }
            this.extent.endTest(extentTest);
        }
    }

    public TestConverter(ExtentReports extent, File file) {
        this.file = file;
        this.extent = extent;
        String source = FileReaderEx.readAllText(file);
        this.doc = Jsoup.parse((String)source);
    }
}

