/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports.model;

import com.relevantcodes.extentreports.LogCounts;
import com.relevantcodes.extentreports.LogStatus;
import com.relevantcodes.extentreports.model.Author;
import com.relevantcodes.extentreports.model.Category;
import com.relevantcodes.extentreports.model.Log;
import com.relevantcodes.extentreports.model.ScreenCapture;
import com.relevantcodes.extentreports.model.Screencast;
import com.relevantcodes.extentreports.model.TestAttribute;
import com.relevantcodes.extentreports.utils.DateTimeUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Test {
    public boolean isChildNode = false;
    public boolean hasEnded = false;
    public boolean hasChildNodes = false;
    private List<TestAttribute> categoryList;
    private List<TestAttribute> authorsList;
    private List<Log> logList;
    private List<ScreenCapture> screenCaptureList;
    private List<Screencast> screencastList;
    private List<Test> nodeList;
    private HashMap<LogStatus, Integer> logCounts;
    private Date startTime;
    private Date endTime;
    private LogStatus status = LogStatus.UNKNOWN;
    private String description;
    private String internalWarning = null;
    private String name;
    private UUID id = UUID.randomUUID();

    public LogIterator logIterator() {
        return new LogIterator();
    }

    public TestAttributeIterator<Author> authorIterator() {
        return new TestAttributeIterator<Author>(Author.class);
    }

    public TestAttributeIterator<Category> categoryIterator() {
        return new TestAttributeIterator<Category>(Category.class);
    }

    private void setLogCounts() {
        this.logCounts = new LogCounts().getLogCounts(this);
    }

    public HashMap<LogStatus, Integer> getLogCounts() {
        return this.logCounts;
    }

    public void setStartedTime(Date startedTime) {
        this.startTime = startedTime;
    }

    public Date getStartedTime() {
        return this.startTime;
    }

    public String getRunDuration() {
        return DateTimeUtil.getDiff(this.endTime, this.startTime);
    }

    public void setEndedTime(Date endedTime) {
        this.endTime = endedTime;
    }

    public Date getEndedTime() {
        return this.endTime;
    }

    public void setStatus(LogStatus status) {
        this.status = status;
    }

    public LogStatus getStatus() {
        return this.status;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setInternalWarning(String warning) {
        this.internalWarning = warning;
    }

    public String getInternalWarning() {
        return this.internalWarning;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UUID getId() {
        return this.id;
    }

    public void setCategory(TestAttribute category) {
        this.categoryList.add(category);
    }

    public List<TestAttribute> getCategoryList() {
        return this.categoryList;
    }

    public void setAuthor(TestAttribute author) {
        this.authorsList.add(author);
    }

    public List<TestAttribute> getAuthorsList() {
        return this.authorsList;
    }

    public void setLog(List<Log> logList) {
        this.logList = logList;
    }

    public void setLog(Log log) {
        this.logList.add(log);
    }

    public List<Log> getLogList() {
        return this.logList;
    }

    public int getLogColumnSize() {
        int logSize = 3;
        if (this.logList.size() > 0 && this.logList.get(0).getStepName() != "") {
            logSize = 4;
        }
        return logSize;
    }

    public void setScreenCaptureList(List<ScreenCapture> screenCaptureList) {
        this.screenCaptureList = screenCaptureList;
    }

    public void setScreenCapture(ScreenCapture screenCapture) {
        this.screenCaptureList.add(screenCapture);
    }

    public List<ScreenCapture> getScreenCaptureList() {
        return this.screenCaptureList;
    }

    public void setScreencastList(List<Screencast> screencastList) {
        this.screencastList = screencastList;
    }

    public void setScreencast(Screencast screencast) {
        this.screencastList.add(screencast);
    }

    public List<Screencast> getScreencastList() {
        return this.screencastList;
    }

    public void setNodeList(List<Test> nodeList) {
        this.nodeList = nodeList;
        this.updateTestStatusRecursively(this);
    }

    public void setNode(Test node) {
        this.nodeList.add(node);
    }

    public List<Test> getNodeList() {
        return this.nodeList;
    }

    public void prepareFinalize() {
        this.setLogCounts();
        this.updateTestStatusRecursively(this);
        if (this.status == LogStatus.INFO) {
            this.status = LogStatus.PASS;
        }
    }

    public void trackLastRunStatus() {
        for (Log l : this.logList) {
            this.findStatus(l.getLogStatus());
        }
        if (this.status == LogStatus.INFO) {
            this.status = LogStatus.PASS;
        }
    }

    private void updateTestStatusRecursively(Test test) {
        for (Log log : test.logList) {
            this.findStatus(log.getLogStatus());
        }
        if (test.hasChildNodes) {
            for (Test node : test.nodeList) {
                this.updateTestStatusRecursively(node);
            }
        }
    }

    private void findStatus(LogStatus logStatus) {
        if (this.status == LogStatus.FATAL) {
            return;
        }
        if (logStatus == LogStatus.FATAL) {
            this.status = logStatus;
            return;
        }
        if (this.status == LogStatus.FAIL) {
            return;
        }
        if (logStatus == LogStatus.FAIL) {
            this.status = logStatus;
            return;
        }
        if (this.status == LogStatus.ERROR) {
            return;
        }
        if (logStatus == LogStatus.ERROR) {
            this.status = logStatus;
            return;
        }
        if (this.status == LogStatus.WARNING) {
            return;
        }
        if (logStatus == LogStatus.WARNING) {
            this.status = logStatus;
            return;
        }
        if (this.status == LogStatus.PASS) {
            return;
        }
        if (logStatus == LogStatus.PASS) {
            this.status = LogStatus.PASS;
            return;
        }
        if (this.status == LogStatus.SKIP) {
            return;
        }
        if (logStatus == LogStatus.SKIP) {
            this.status = LogStatus.SKIP;
            return;
        }
        if (this.status == LogStatus.INFO) {
            return;
        }
        if (logStatus == LogStatus.INFO) {
            this.status = LogStatus.INFO;
            return;
        }
        this.status = LogStatus.UNKNOWN;
    }

    public Test() {
        this.setStartedTime(Calendar.getInstance().getTime());
        this.logList = new ArrayList<Log>();
        this.categoryList = new ArrayList<TestAttribute>();
        this.authorsList = new ArrayList<TestAttribute>();
        this.screenCaptureList = new ArrayList<ScreenCapture>();
        this.screencastList = new ArrayList<Screencast>();
        this.nodeList = new ArrayList<Test>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestAttributeIterator<T extends TestAttribute>
    implements Iterator<TestAttribute> {
        private int attrIterIndex = 0;
        private List<TestAttribute> list;

        public TestAttributeIterator(Class<T> type) {
            this.list = type == Category.class ? Test.this.categoryList : Test.this.authorsList;
        }

        @Override
        public boolean hasNext() {
            return this.list != null && this.list.size() >= this.attrIterIndex + 1;
        }

        @Override
        public TestAttribute next() {
            if (this.hasNext()) {
                return this.list.get(this.attrIterIndex++);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LogIterator
    implements Iterator<Log> {
        private int logIterIndex = 0;

        @Override
        public boolean hasNext() {
            return Test.this.logList != null && Test.this.logList.size() >= this.logIterIndex + 1;
        }

        @Override
        public Log next() {
            if (this.hasNext()) {
                return (Log)Test.this.logList.get(this.logIterIndex++);
            }
            return null;
        }
    }
}

