/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateTimeUtil {
    public static Date getDate(String date, String pattern) {
        SimpleDateFormat sdfDate = new SimpleDateFormat(pattern);
        try {
            return sdfDate.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getFormattedDateTime(Date date, String pattern) {
        SimpleDateFormat sdfDate = new SimpleDateFormat(pattern);
        return sdfDate.format(date);
    }

    public static String getFormattedDateTime(String dateTime, String pattern) {
        SimpleDateFormat sdfDate = new SimpleDateFormat(pattern);
        SimpleDateFormat format = new SimpleDateFormat(pattern, Locale.ENGLISH);
        try {
            Date date = format.parse(dateTime);
            return sdfDate.format(date);
        }
        catch (ParseException e) {
            return dateTime;
        }
    }

    public static String getFormattedDateTime(long millis, String pattern) {
        SimpleDateFormat sdfDate = new SimpleDateFormat(pattern);
        Date date = new Date(millis);
        return sdfDate.format(date);
    }

    public static String getDiff(Date endDate, Date startDate) {
        return DateTimeUtil.getDiff(endDate.getTime(), startDate.getTime());
    }

    public static String getDiff(long endDate, long startDate) {
        long diff = endDate - startDate;
        long secs = diff / 1000L;
        long millis = diff % 1000L;
        long mins = secs / 60L;
        long hours = mins / 60L;
        return hours + "h " + (mins %= 60L) + "m " + (secs %= 60L) + "s+" + millis + "ms";
    }
}

