/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports;

import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.relevantcodes.extentreports.Configuration;
import com.relevantcodes.extentreports.DBReporter;
import com.relevantcodes.extentreports.DisplayOrder;
import com.relevantcodes.extentreports.ExtentTest;
import com.relevantcodes.extentreports.ExtentX;
import com.relevantcodes.extentreports.HTMLReporter;
import com.relevantcodes.extentreports.NetworkMode;
import com.relevantcodes.extentreports.Report;
import com.relevantcodes.extentreports.ReporterType;
import com.relevantcodes.extentreports.converters.ReportParser;
import com.relevantcodes.extentreports.converters.TestConverter;
import com.relevantcodes.extentreports.model.Test;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtentReports
extends Report
implements Serializable {
    private static final Logger logger = Logger.getLogger(ExtentReports.class.getName());

    public ExtentReports(String filePath, Boolean replaceExisting, DisplayOrder displayOrder, NetworkMode networkMode, Locale locale) {
        File file;
        replaceExisting = replaceExisting == null ? true : replaceExisting;
        displayOrder = displayOrder == null ? DisplayOrder.OLDEST_FIRST : displayOrder;
        networkMode = networkMode == null ? NetworkMode.ONLINE : networkMode;
        locale = locale == null ? Locale.ENGLISH : locale;
        this.setFilePath(filePath);
        this.setReplaceExisting(replaceExisting);
        this.setDisplayOrder(displayOrder);
        this.setNetworkMode(networkMode);
        this.setDocumentLocale(locale);
        this.attach(new HTMLReporter(filePath));
        if (!replaceExisting.booleanValue() && (file = new File(filePath)).exists()) {
            TestConverter converter = new TestConverter(this, file);
            converter.createTestList();
            this.convertUpdateLastRunDuration();
            ReportParser reportParser = new ReportParser(file);
            this.setMongoDBObjectID(reportParser.getMongoDBObjectID());
        }
    }

    public ExtentReports(String filePath, Boolean replaceExisting, DisplayOrder displayOrder, NetworkMode networkMode) {
        this(filePath, replaceExisting, displayOrder, networkMode, null);
    }

    public ExtentReports(String filePath, Boolean replaceExisting, DisplayOrder displayOrder, Locale locale) {
        this(filePath, replaceExisting, displayOrder, null, locale);
    }

    public ExtentReports(String filePath, Boolean replaceExisting, DisplayOrder displayOrder) {
        this(filePath, replaceExisting, displayOrder, null, null);
    }

    public ExtentReports(String filePath, Boolean replaceExisting, NetworkMode networkMode, Locale locale) {
        this(filePath, replaceExisting, null, networkMode, locale);
    }

    public ExtentReports(String filePath, Boolean replaceExisting, NetworkMode networkMode) {
        this(filePath, replaceExisting, null, networkMode, null);
    }

    public ExtentReports(String filePath, NetworkMode networkMode) {
        this(filePath, null, null, networkMode, null);
    }

    public ExtentReports(String filePath, Boolean replaceExisting, Locale locale) {
        this(filePath, replaceExisting, null, null, locale);
    }

    public ExtentReports(String filePath, Boolean replaceExisting) {
        this(filePath, replaceExisting, null, null, null);
    }

    public ExtentReports(String filePath, Locale locale) {
        this(filePath, null, null, null, locale);
    }

    public ExtentReports(String filePath) {
        this(filePath, null, null, null, null);
    }

    public ExtentReports assignProject(String name) {
        this.setProjectName(name);
        return this;
    }

    public UUID getReportId() {
        return this.getId();
    }

    public void loadConfig(File configFile) {
        if (!configFile.exists()) {
            logger.log(Level.WARNING, "Unable to perform report configuration. The file " + configFile.getAbsolutePath() + " was not found.");
            return;
        }
        if (!configFile.getName().endsWith(".xml")) {
            logger.log(Level.WARNING, "Unable to perform report configuration. The file " + configFile.getAbsolutePath() + " must be an XML file.");
            return;
        }
        this.loadConfig(new Configuration(configFile));
    }

    public void loadConfig(URL url) {
        this.loadConfig(new Configuration(url));
    }

    public void loadConfig(Class clazz, String fileName) {
        this.loadConfig(clazz, null, fileName);
    }

    public void loadConfig(Class clazz, String basePackagePath, String fileName) {
        URL url;
        String fullPackagePath = clazz.getPackage().getName().replace(".", File.separator) + File.separator + fileName;
        if (basePackagePath != null) {
            fullPackagePath = clazz.getPackage().getName().replace(".", File.separator) + File.separator + basePackagePath + File.separator + fileName;
        }
        if ((url = this.getClass().getClassLoader().getResource(fullPackagePath)) == null) {
            logger.log(Level.WARNING, "Unable to perform report configuration. The package or file " + fullPackagePath + " was not found.");
            return;
        }
        this.loadConfig(new Configuration(url));
    }

    public void x() {
        this.attach(new ExtentX());
    }

    public void x(String host) {
        this.attach(new ExtentX(host));
    }

    public void x(String host, int port) {
        this.attach(new ExtentX(host, port));
    }

    public void x(MongoClientURI uri) {
        this.attach(new ExtentX(uri));
    }

    public void x(String host, MongoClientOptions options) {
        this.attach(new ExtentX(host, options));
    }

    public void x(ServerAddress addr) {
        this.attach(new ExtentX(addr));
    }

    public void x(List<ServerAddress> seeds) {
        this.attach(new ExtentX(seeds));
    }

    public void x(List<ServerAddress> seeds, List<MongoCredential> credentialsList) {
        this.attach(new ExtentX(seeds, credentialsList));
    }

    public void x(List<ServerAddress> seeds, List<MongoCredential> credentialsList, MongoClientOptions options) {
        this.attach(new ExtentX(seeds, credentialsList, options));
    }

    public void x(List<ServerAddress> seeds, MongoClientOptions options) {
        this.attach(new ExtentX(seeds, options));
    }

    public void x(ServerAddress addr, List<MongoCredential> credentialsList) {
        this.attach(new ExtentX(addr, credentialsList));
    }

    public void x(ServerAddress addr, List<MongoCredential> credentialsList, MongoClientOptions options) {
        this.attach(new ExtentX(addr, credentialsList, options));
    }

    public void x(ServerAddress addr, MongoClientOptions options) {
        this.attach(new ExtentX(addr, options));
    }

    public synchronized ExtentReports startReporter(ReporterType reporterType, String filePath) {
        if (reporterType == ReporterType.DB) {
            this.attach(new DBReporter(filePath));
        }
        return this;
    }

    public synchronized ExtentTest startTest(String testName, String description) {
        if (this.testList == null) {
            this.testList = new ArrayList();
        }
        ExtentTest test = new ExtentTest(testName, description);
        this.updateTestQueue(test);
        return test;
    }

    public synchronized ExtentTest startTest(String testName) {
        return this.startTest(testName, "");
    }

    public synchronized void endTest(ExtentTest extentTest) {
        if (extentTest != null && !extentTest.getInternalTest().isChildNode) {
            Test test = extentTest.getInternalTest();
            if (!test.hasEnded) {
                test.hasEnded = true;
                this.finalizeTest(test);
            }
        }
    }

    public ExtentReports addSystemInfo(Map<String, String> info) {
        if (info != null) {
            this.systemInfo.setInfo(info);
        }
        return this;
    }

    public ExtentReports addSystemInfo(String param, String value) {
        if (param != null) {
            this.systemInfo.setInfo(param, value);
        }
        return this;
    }

    public void setTestRunnerOutput(String log) {
        this.setTestRunnerLogs(log);
    }

    @Override
    public synchronized void flush() {
        this.removeChildTests();
        super.flush();
    }

    public synchronized void close() {
        this.terminate();
        if (this.testList != null) {
            this.testList.clear();
        }
    }

    @Deprecated
    public HTMLReporter.Config config() {
        HTMLReporter hr = new HTMLReporter(null);
        return new HTMLReporter.Config(hr);
    }

    private synchronized void removeChildTests() {
        if (this.testList == null) {
            return;
        }
        Iterator iterator = this.testList.iterator();
        while (iterator.hasNext()) {
            Test t = ((ExtentTest)iterator.next()).getInternalTest();
            if (!t.isChildNode) continue;
            iterator.remove();
        }
    }
}

