/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wrapper;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class BootstrapMainStarter {
    private static final String ERROR_TEMPLATE = "Could not locate the Maven launcher JAR in Maven distribution '%s'.";

    public void start(String[] args, File mavenHome) throws Exception {
        File mavenJar = this.findLauncherJar(mavenHome);
        ClassLoader contextClassLoader = this.createUrlClassLoader(mavenJar);
        Thread.currentThread().setContextClassLoader(contextClassLoader);
        Class<?> mainClass = contextClassLoader.loadClass("org.codehaus.plexus.classworlds.launcher.Launcher");
        System.setProperty("maven.home", mavenHome.getAbsolutePath());
        System.setProperty("classworlds.conf", new File(mavenHome, "/bin/m2.conf").getAbsolutePath());
        Method mainMethod = mainClass.getMethod("main", String[].class);
        mainMethod.invoke(null, new Object[]{args});
    }

    private ClassLoader createUrlClassLoader(File mavenJar) throws MalformedURLException {
        URL[] urls = new URL[]{mavenJar.toURI().toURL()};
        ClassLoader parentClassLoader = ClassLoader.getSystemClassLoader().getParent();
        URLClassLoader contextClassLoader = new URLClassLoader(urls, parentClassLoader);
        return contextClassLoader;
    }

    private File findLauncherJar(File mavenHome) {
        for (File file : new File(mavenHome, "boot").listFiles()) {
            if (!file.getName().matches("plexus-classworlds-.*\\.jar")) continue;
            return file;
        }
        throw new RuntimeException(String.format(ERROR_TEMPLATE, mavenHome));
    }
}

