/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wrapper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.maven.wrapper.Downloader;

public class DefaultDownloader
implements Downloader {
    private static final int PROGRESS_CHUNK = 20000;
    private static final int BUFFER_SIZE = 10000;
    private final String applicationName;
    private final String applicationVersion;

    public DefaultDownloader(String applicationName, String applicationVersion) {
        this.applicationName = applicationName;
        this.applicationVersion = applicationVersion;
        this.configureProxyAuthentication();
    }

    private void configureProxyAuthentication() {
        if (System.getProperty("http.proxyUser") != null) {
            Authenticator.setDefault(new SystemPropertiesProxyAuthenticator());
        }
    }

    @Override
    public void download(URI address, File destination) throws Exception {
        if (destination.exists()) {
            return;
        }
        destination.getParentFile().mkdirs();
        this.downloadInternal(address, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadInternal(URI address, File destination) throws IOException {
        WritableByteChannel out = null;
        Channel in = null;
        try {
            int numRead;
            URL url = address.toURL();
            out = Channels.newChannel(new FileOutputStream(destination));
            URLConnection conn = url.openConnection();
            String userAgentValue = this.calculateUserAgent();
            conn.setRequestProperty("User-Agent", userAgentValue);
            in = Channels.newChannel(conn.getInputStream());
            long progressCounter = 0L;
            ByteBuffer buffer = ByteBuffer.allocate(10000);
            while ((numRead = in.read(buffer)) >= 0 || buffer.position() > 0) {
                buffer.flip();
                if ((progressCounter += (long)numRead) / 20000L > 0L) {
                    System.out.print(".");
                    progressCounter -= 20000L;
                }
                out.write(buffer);
                buffer.clear();
            }
        }
        finally {
            System.out.println("");
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private String calculateUserAgent() {
        String javaVendor = System.getProperty("java.vendor");
        String javaVersion = System.getProperty("java.version");
        String javaVendorVersion = System.getProperty("java.vm.version");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        return String.format("%s/%s (%s;%s;%s) (%s;%s;%s)", this.applicationName, this.applicationVersion, osName, osVersion, osArch, javaVendor, javaVersion, javaVendorVersion);
    }

    private static class SystemPropertiesProxyAuthenticator
    extends Authenticator {
        private SystemPropertiesProxyAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            String username = System.getProperty("http.proxyUser");
            char[] password = System.getProperty("http.proxyPassword", "").toCharArray();
            return new PasswordAuthentication(username, password);
        }
    }
}

