/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.log4j;

import com.ryantenney.log4j.NamedThreadFactory;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import redis.clients.jedis.Jedis;
import redis.clients.util.SafeEncoder;

public class RedisAppender
extends AppenderSkeleton
implements Runnable {
    private String host = "localhost";
    private int port = 6379;
    private String password;
    private String key;
    private int batchSize = 100;
    private long period = 500L;
    private boolean alwaysBatch = true;
    private boolean purgeOnFailure = true;
    private boolean daemonThread = true;
    private int messageIndex = 0;
    private Queue<LoggingEvent> events;
    private byte[][] batch;
    private Jedis jedis;
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> task;

    public void activateOptions() {
        try {
            super.activateOptions();
            if (this.key == null) {
                throw new IllegalStateException("Must set 'key'");
            }
            if (this.executor == null) {
                this.executor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("RedisAppender", this.daemonThread));
            }
            if (this.task != null && !this.task.isDone()) {
                this.task.cancel(true);
            }
            if (this.jedis != null && this.jedis.isConnected()) {
                this.jedis.disconnect();
            }
            this.events = new ConcurrentLinkedQueue<LoggingEvent>();
            this.batch = new byte[this.batchSize][];
            this.messageIndex = 0;
            this.jedis = new Jedis(this.host, this.port);
            this.task = this.executor.scheduleWithFixedDelay(this, this.period, this.period, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LogLog.error((String)"Error during activateOptions", (Throwable)e);
        }
    }

    protected void append(LoggingEvent event) {
        try {
            this.populateEvent(event);
            this.events.add(event);
        }
        catch (Exception e) {
            this.errorHandler.error("Error populating event and adding to queue", e, 0, event);
        }
    }

    protected void populateEvent(LoggingEvent event) {
        event.getThreadName();
        event.getRenderedMessage();
        event.getNDC();
        event.getMDCCopy();
        event.getThrowableStrRep();
        event.getLocationInformation();
    }

    public void close() {
        try {
            this.task.cancel(false);
            this.executor.shutdown();
            this.jedis.disconnect();
        }
        catch (Exception e) {
            this.errorHandler.error(e.getMessage(), e, 3);
        }
    }

    private boolean connect() {
        try {
            if (!this.jedis.isConnected()) {
                String result;
                LogLog.debug((String)("Connecting to Redis: " + this.host));
                this.jedis.connect();
                if (this.password != null && !"OK".equals(result = this.jedis.auth(this.password))) {
                    LogLog.error((String)("Error authenticating with Redis: " + this.host));
                }
            }
            return true;
        }
        catch (Exception e) {
            LogLog.error((String)"Error connecting to Redis server", (Throwable)e);
            return false;
        }
    }

    @Override
    public void run() {
        if (!this.connect()) {
            if (this.purgeOnFailure) {
                LogLog.debug((String)"Purging event queue");
                this.events.clear();
                this.messageIndex = 0;
            }
            return;
        }
        try {
            LoggingEvent event;
            if (this.messageIndex == this.batchSize) {
                this.push();
            }
            while ((event = this.events.poll()) != null) {
                try {
                    String message = this.layout.format(event);
                    this.batch[this.messageIndex++] = SafeEncoder.encode((String)message);
                }
                catch (Exception e) {
                    this.errorHandler.error(e.getMessage(), e, 0, event);
                }
                if (this.messageIndex != this.batchSize) continue;
                this.push();
            }
            if (!this.alwaysBatch && this.messageIndex > 0) {
                this.push();
            }
        }
        catch (Exception e) {
            this.errorHandler.error(e.getMessage(), e, 1);
        }
    }

    private void push() {
        LogLog.debug((String)("Sending " + this.messageIndex + " log messages to Redis"));
        this.jedis.rpush(SafeEncoder.encode((String)this.key), this.batchSize == this.messageIndex ? this.batch : (byte[][])Arrays.copyOf(this.batch, this.messageIndex));
        this.messageIndex = 0;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPeriod(long millis) {
        this.period = millis;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setBatchSize(int batchsize) {
        this.batchSize = batchsize;
    }

    public void setPurgeOnFailure(boolean purgeOnFailure) {
        this.purgeOnFailure = purgeOnFailure;
    }

    public void setAlwaysBatch(boolean alwaysBatch) {
        this.alwaysBatch = alwaysBatch;
    }

    public void setDaemonThread(boolean daemonThread) {
        this.daemonThread = daemonThread;
    }

    public boolean requiresLayout() {
        return true;
    }
}

