/*
 * Decompiled with CFR 0.152.
 */
package com.sap.prd.mobile.ios.maven.plugins.pomresolver;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="resolve-pom-props", defaultPhase=LifecyclePhase.INITIALIZE)
public class ResolvePomPropsMojo
extends AbstractMojo {
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(property="pomresolver.resolvedPomName", defaultValue="resolvedPom.xml")
    protected String resolvedPomName;
    @Component(role=MavenResourcesFiltering.class, hint="default")
    protected MavenResourcesFiltering mavenResourcesFiltering;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;

    public void execute() throws MojoExecutionException {
        try {
            File origPomFile = this.project.getFile();
            File intermediatePomFile = new File(this.project.getBuild().getDirectory() + File.separator + origPomFile.getName());
            File resolvedPomFile = new File(origPomFile.getParentFile(), this.resolvedPomName);
            Resource pomResource = new Resource();
            pomResource.setDirectory(origPomFile.getParent());
            pomResource.setFiltering(true);
            pomResource.addInclude(origPomFile.getName());
            pomResource.setTargetPath(intermediatePomFile.getParent());
            ArrayList<Resource> resources = new ArrayList<Resource>();
            resources.add(pomResource);
            MavenResourcesExecution resourceExecution = new MavenResourcesExecution(resources, intermediatePomFile.getParentFile(), this.project, this.encoding, null, null, this.session);
            resourceExecution.setOverwrite(true);
            this.mavenResourcesFiltering.filterResources(resourceExecution);
            String origPomContent = FileUtils.fileRead((File)origPomFile);
            String newPomContent = FileUtils.fileRead((File)intermediatePomFile);
            if (resolvedPomFile.isFile()) {
                resolvedPomFile.delete();
            }
            if (!origPomContent.equals(newPomContent)) {
                FileUtils.copyFile((File)intermediatePomFile, (File)resolvedPomFile);
                this.project.setFile(resolvedPomFile);
                this.getLog().info((CharSequence)("Created a POM file '" + resolvedPomFile.getName() + "' where all variables are resolved and that is used for further processing." + " Especially this POM file will get uploaded into the local and remote repository."));
            } else {
                this.getLog().info((CharSequence)"No properties got replaced in the POM. Keeping the original file.");
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Failed to create resolved POM", ex);
        }
    }
}

