/*
 * Decompiled with CFR 0.152.
 */
package com.savage7.maven.plugin.dependency;

import com.savage7.maven.plugin.dependency.ArtifactItem;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.install.AbstractInstallMojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.digest.Digester;
import org.codehaus.plexus.digest.DigesterException;
import org.codehaus.plexus.digest.Md5Digester;
import org.codehaus.plexus.digest.Sha1Digester;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractExternalDependencyMojo
extends AbstractInstallMojo {
    protected ArtifactFactory artifactFactory;
    protected ArrayList<ArtifactItem> artifactItems;
    protected MavenProject project;
    protected String stagingDirectory;
    protected Boolean force = false;
    protected Boolean skipChecksumVerification = false;

    protected Artifact createArtifact(ArtifactItem item) {
        Artifact artifact = null;
        artifact = this.artifactFactory.createArtifactWithClassifier(item.getGroupId(), item.getArtifactId(), item.getVersion(), item.getPackaging(), item.getClassifier());
        return artifact;
    }

    protected File generatePomFile(ArtifactItem artifact) throws MojoExecutionException {
        File file;
        Model model = this.generateModel(artifact);
        XmlStreamWriter writer = null;
        try {
            File pomFile = File.createTempFile(artifact.getGroupId() + "." + artifact.getArtifactId(), ".pom");
            writer = WriterFactory.newXmlWriter((File)pomFile);
            new MavenXpp3Writer().write((Writer)writer, model);
            file = pomFile;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error writing temporary POM file: " + e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
        return file;
    }

    protected Model generateModel(ArtifactItem artifact) {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(artifact.getGroupId());
        model.setArtifactId(artifact.getArtifactId());
        model.setVersion(artifact.getVersion());
        model.setPackaging(artifact.getPackaging());
        return model;
    }

    protected File getFullyQualifiedArtifactFilePath(ArtifactItem artifactItem) {
        String artifactStagingDirectory = artifactItem.getStagingDirectory();
        if (artifactStagingDirectory == null || artifactStagingDirectory.isEmpty()) {
            artifactStagingDirectory = this.stagingDirectory;
        }
        return new File(artifactStagingDirectory + File.separator + artifactItem.getLocalFile());
    }

    protected boolean verifyChecksum(File targetFile, Digester digester, String checksum) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Calculating " + digester.getAlgorithm() + " checksum for " + targetFile));
        try {
            String calculatedChecksum = digester.calc(targetFile);
            this.getLog().debug((CharSequence)("Generated checksum : " + calculatedChecksum));
            this.getLog().debug((CharSequence)("Expected checksum  : " + checksum));
            return calculatedChecksum.equals(checksum);
        }
        catch (DigesterException e) {
            throw new MojoExecutionException("Failed to calculate " + digester.getAlgorithm() + " checksum for " + targetFile, (Exception)((Object)e));
        }
    }

    protected void verifyArtifactItemChecksum(ArtifactItem artifactItem, File targetFile) throws MojoExecutionException, MojoFailureException, IOException {
        if (artifactItem.hasChecksum()) {
            this.getLog().info((CharSequence)("verifying checksum on downloaded file: CKSM=" + artifactItem.getChecksum()));
            this.getLog().info((CharSequence)("testing for MD5 checksum on artifact: " + artifactItem.toString()));
            if (!this.verifyChecksum(targetFile, (Digester)new Md5Digester(), artifactItem.getChecksum())) {
                this.getLog().info((CharSequence)("verification failed on MD5 checksum for file: " + targetFile.getCanonicalPath()));
                this.getLog().info((CharSequence)("testing for SHA1 checksum on artifact: " + artifactItem.toString()));
                if (!this.verifyChecksum(targetFile, (Digester)new Sha1Digester(), artifactItem.getChecksum())) {
                    throw new MojoFailureException("Both MD5 and SHA1 checksum verification failed for: \r\n   groupId    : " + artifactItem.getGroupId() + "\r\n   artifactId : " + artifactItem.getArtifactId() + "\r\n   version    : " + artifactItem.getVersion() + "\r\n   checksum   : " + artifactItem.getChecksum() + "\r\n   file       : " + targetFile.getCanonicalPath());
                }
                this.getLog().info((CharSequence)("verification passed on SHA1 checksum for artifact: " + artifactItem.toString()));
            } else {
                this.getLog().info((CharSequence)("verification passed on MD5 checksum for artifact: " + artifactItem.toString()));
            }
        }
    }

    protected void verifyArtifactItemExtractFileChecksum(ArtifactItem artifactItem, File targetFile) throws MojoExecutionException, MojoFailureException, IOException {
        if (artifactItem.hasExtractFileChecksum()) {
            this.getLog().info((CharSequence)("verifying checksum on extracted file: CKSM=" + artifactItem.getChecksum()));
            this.getLog().info((CharSequence)("testing for MD5 checksum on artifact: " + artifactItem.toString()));
            if (!this.verifyChecksum(targetFile, (Digester)new Md5Digester(), artifactItem.getExtractFileChecksum())) {
                this.getLog().info((CharSequence)("verification failed on MD5 checksum for extracted file: " + targetFile.getCanonicalPath()));
                this.getLog().info((CharSequence)("testing for SHA1 checksum on artifact: " + artifactItem.toString()));
                if (!this.verifyChecksum(targetFile, (Digester)new Sha1Digester(), artifactItem.getExtractFileChecksum())) {
                    throw new MojoFailureException("Both MD5 and SHA1 checksum verification failed for: \r\n   groupId        : " + artifactItem.getGroupId() + "\r\n   artifactId     : " + artifactItem.getArtifactId() + "\r\n   version        : " + artifactItem.getVersion() + "\r\n   checksum       : " + artifactItem.getChecksum() + "\r\n   extracted file : " + targetFile.getCanonicalPath());
                }
                this.getLog().info((CharSequence)("verification passed on SHA1 checksum for artifact: " + artifactItem.toString()));
            } else {
                this.getLog().info((CharSequence)("verification passed on MD5 checksum for artifact: " + artifactItem.toString()));
            }
        }
    }

    protected void verifyArtifactItemChecksumBySonatypeLookup(ArtifactItem artifactItem, File targetFile) throws MojoExecutionException, MojoFailureException, IOException {
        if (this.skipChecksumVerification.booleanValue() || artifactItem.getSkipChecksumVerification().booleanValue()) {
            return;
        }
        boolean artifactMismatch = false;
        StringBuilder detectedArtifacts = new StringBuilder();
        try {
            String sha1Checksum = this.sha1Digester.calc(targetFile);
            this.getLog().debug((CharSequence)("performing Sonatype lookup on artifact SHA1 checksum: " + sha1Checksum));
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.parse("http://repository.sonatype.org/service/local/data_index?sha1=" + sha1Checksum);
            NodeList artifactList = document.getElementsByTagName("artifact");
            if (artifactList != null && artifactList.getLength() > 0) {
                int nodeCount = artifactList.getLength();
                this.getLog().info((CharSequence)(nodeCount + " existing artifacts found in Sonatype checksum lookup.  verifying artifact GAV."));
                for (int index = 0; index < nodeCount; ++index) {
                    Node artifactNode = artifactList.item(index);
                    if (artifactNode.hasChildNodes()) {
                        NodeList children = artifactNode.getChildNodes();
                        for (int loop = 0; loop < children.getLength(); ++loop) {
                            Node artifactProperty = children.item(loop);
                            if (!artifactProperty.getNodeName().equalsIgnoreCase("#text")) {
                                detectedArtifacts.append("\n       " + artifactProperty.getNodeName() + " : " + artifactProperty.getTextContent());
                            }
                            if (artifactProperty.getNodeName().equalsIgnoreCase("groupId")) {
                                if (artifactProperty.getTextContent().equalsIgnoreCase(artifactItem.getGroupId())) continue;
                                this.getLog().error((CharSequence)("artifact found in Sonatype lookup does not match: " + artifactProperty.getNodeName() + ":" + artifactProperty.getTextContent() + " != " + artifactItem.getGroupId()));
                                artifactMismatch = true;
                                continue;
                            }
                            if (artifactProperty.getNodeName().equalsIgnoreCase("artifactId")) {
                                if (artifactProperty.getTextContent().equalsIgnoreCase(artifactItem.getArtifactId())) continue;
                                this.getLog().error((CharSequence)("artifact found in Sonatype lookup does not match: " + artifactProperty.getNodeName() + ":" + artifactProperty.getTextContent() + " != " + artifactItem.getArtifactId()));
                                artifactMismatch = true;
                                continue;
                            }
                            if (!artifactProperty.getNodeName().equalsIgnoreCase("version") || artifactProperty.getTextContent().equalsIgnoreCase(artifactItem.getVersion())) continue;
                            this.getLog().error((CharSequence)("artifact found in Sonatype lookup does not match: " + artifactProperty.getNodeName() + ":" + artifactProperty.getTextContent() + " != " + artifactItem.getVersion()));
                            artifactMismatch = true;
                        }
                    }
                    detectedArtifacts.append("\n");
                }
            } else {
                this.getLog().debug((CharSequence)"no existing artifacts found in Sonatype checksum lookup.  continue with artifact installation.");
            }
        }
        catch (Exception ex) {
            this.getLog().error((Throwable)ex);
        }
        if (artifactMismatch) {
            throw new MojoFailureException("Sonatype artifact checksum verification failed on artifact defined in POM: \n\n       groupId    : " + artifactItem.getGroupId() + "\n       artifactId : " + artifactItem.getArtifactId() + "\n       version    : " + artifactItem.getVersion() + "\n       checksum   : " + artifactItem.getChecksum() + "\n       file       : " + targetFile.getCanonicalPath() + "\n\n The following artifact(s) were detected using the same checksum:\n" + detectedArtifacts.toString() + "\n\n Please verify that the GAV defined on the target artifact is correct.\n");
        }
    }
}

