/*
 * Decompiled with CFR 0.152.
 */
package com.savage7.maven.plugin.dependency;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.util.StringUtils;

public class ArtifactItem {
    private String groupId;
    private String artifactId;
    private String version = null;
    private String classifier;
    private String localFile = "{artifactId}-{version}-{classifier}.{packaging}";
    private String stagingDirectory;
    private String downloadUrl;
    private String packaging;
    private Boolean install = true;
    private Boolean deploy = true;
    private Boolean force = false;
    private File pomFile;
    private Boolean generatePom = true;
    private String createChecksum;
    private Boolean skipChecksumVerification = false;
    private String checksum;
    private String extractFile;
    private String extractFileChecksum;
    private boolean repack = false;

    public ArtifactItem() {
    }

    public ArtifactItem(Artifact artifact) {
        this.setArtifactId(artifact.getArtifactId());
        this.setClassifier(artifact.getClassifier());
        this.setGroupId(artifact.getGroupId());
        this.setPackaging(artifact.getType());
        this.setVersion(artifact.getVersion());
    }

    private String filterEmptyString(String in) {
        if (in == null || in.equals("")) {
            return null;
        }
        return in;
    }

    public final String getArtifactId() {
        return this.artifactId;
    }

    public final void setArtifactId(String artifact) {
        this.artifactId = this.filterEmptyString(artifact);
    }

    public final String getGroupId() {
        return this.groupId;
    }

    public final void setGroupId(String groupId) {
        this.groupId = this.filterEmptyString(groupId);
    }

    public final String getType() {
        return this.getPackaging();
    }

    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(String version) {
        this.version = this.filterEmptyString(version);
    }

    public final String getClassifier() {
        return this.classifier;
    }

    public final void setClassifier(String classifier) {
        this.classifier = this.filterEmptyString(classifier);
    }

    public final String toString() {
        if (this.classifier == null) {
            return this.groupId + ":" + this.artifactId + ":" + StringUtils.defaultString((Object)this.version, (String)"?") + ":" + this.packaging;
        }
        return this.groupId + ":" + this.artifactId + ":" + this.classifier + ":" + StringUtils.defaultString((Object)this.version, (String)"?") + ":" + this.packaging;
    }

    public final String getLocalFile() {
        return this.replaceTokens(this.localFile);
    }

    public final void setLocalFile(String localFile) {
        this.localFile = this.filterEmptyString(localFile);
    }

    public final String getStagingDirectory() {
        return this.replaceTokens(this.stagingDirectory);
    }

    public final void setStagingDirectory(String stagingDirectory) {
        this.stagingDirectory = this.filterEmptyString(stagingDirectory);
    }

    public final String getDownloadUrl() {
        return this.replaceTokens(this.downloadUrl);
    }

    public final void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = this.filterEmptyString(downloadUrl);
    }

    public final String getPackaging() {
        return this.packaging;
    }

    public final void setPackaging(String packaging) {
        this.packaging = this.filterEmptyString(packaging);
    }

    public final Boolean getForce() {
        return this.force;
    }

    public final void setForce(Boolean force) {
        this.force = force;
    }

    public final Boolean getInstall() {
        return this.install;
    }

    public final void setInstall(Boolean install) {
        this.install = install;
    }

    public final Boolean getDeploy() {
        return this.deploy;
    }

    public final void setDeploy(Boolean deploy) {
        this.deploy = deploy;
    }

    public final File getPomFile() {
        return this.pomFile;
    }

    public final void setPomFile(File pomFile) {
        this.pomFile = pomFile;
    }

    public final Boolean getGeneratePom() {
        return this.generatePom;
    }

    public final void setGeneratePom(Boolean generatePom) {
        this.generatePom = generatePom;
    }

    public final String getCreateChecksum() {
        return this.createChecksum;
    }

    public final void setCreateChecksum(String createChecksum) {
        this.createChecksum = this.filterEmptyString(createChecksum);
    }

    public final String getChecksum() {
        return this.checksum;
    }

    public final boolean hasChecksum() {
        return this.checksum != null && !this.checksum.isEmpty();
    }

    public final boolean hasExtractFileChecksum() {
        return this.hasChecksum() && this.extractFileChecksum != null && !this.extractFileChecksum.isEmpty();
    }

    public final String getExtractFileChecksum() {
        return this.extractFileChecksum;
    }

    public final void setChecksum(String checksum) {
        this.checksum = this.filterEmptyString(checksum);
    }

    public final Boolean getSkipChecksumVerification() {
        return this.skipChecksumVerification;
    }

    public final void setSkipChecksumVerification(Boolean skipChecksumVerification) {
        this.skipChecksumVerification = skipChecksumVerification;
    }

    public final String getExtractFile() {
        return this.replaceTokens(this.extractFile);
    }

    public final boolean hasExtractFile() {
        return this.extractFile != null && !this.extractFile.isEmpty();
    }

    public final void setExtractFile(String extractFile) {
        this.extractFile = this.filterEmptyString(extractFile);
    }

    private String replaceTokens(String source) {
        String target = source;
        if (target == null) {
            return null;
        }
        if (target.isEmpty()) {
            return target;
        }
        if (this.getGroupId() != null) {
            target = target.replace("{groupId}", this.getGroupId());
        }
        if (this.getArtifactId() != null) {
            target = target.replace("{artifactId}", this.getArtifactId());
        }
        if (this.getVersion() != null) {
            target = target.replace("{version}", this.getVersion());
        }
        if (this.getVersion() != null) {
            target = target.replace("{_version}", this.getVersion().replace(".", "_"));
        }
        if (this.getPackaging() != null) {
            target = target.replace("{packaging}", this.getPackaging());
        }
        target = this.getClassifier() != null ? target.replace("{classifier}", this.getClassifier()) : target.replace("-{classifier}", "");
        if (this.getType() != null) {
            target = target.replace("{type}", this.getType());
        }
        return target;
    }

    public boolean isRepack() {
        return this.repack;
    }

    public void setRepack(boolean repack) {
        this.repack = repack;
    }
}

