/*
 * Decompiled with CFR 0.152.
 */
package com.savage7.maven.plugin.dependency;

import com.savage7.maven.plugin.dependency.AbstractExternalDependencyMojo;
import com.savage7.maven.plugin.dependency.ArtifactItem;
import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;

public class DeployExternalDependencyMojo
extends AbstractExternalDependencyMojo {
    protected ArtifactRepository localRepository;
    protected ArtifactResolver artifactResolver;
    private ArtifactDeployer artifactDeployer;
    private boolean offline;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ((AbstractExternalDependencyMojo)this).localRepository = this.localRepository;
        this.getLog().info((CharSequence)"starting to deploy external dependencies to distribution repository");
        for (ArtifactItem artifactItem : this.artifactItems) {
            this.getLog().info((CharSequence)("resolving artifact in locale repository for deployment: " + artifactItem.toString()));
            Artifact artifact = this.createArtifact(artifactItem);
            File installedArtifactFile = this.getLocalRepoFile(artifact);
            if (installedArtifactFile.exists()) {
                try {
                    this.artifactResolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
                    if (artifactItem.getDeploy().booleanValue()) {
                        File sshFile;
                        this.failIfOffline();
                        ArtifactRepository repo = this.getDeploymentRepository();
                        String protocol = repo.getProtocol();
                        if (protocol.equalsIgnoreCase("scp") && !(sshFile = new File(System.getProperty("user.home"), ".ssh")).exists()) {
                            sshFile.mkdirs();
                        }
                        File generatedPomFile = null;
                        if (!"pom".equals(artifactItem.getPackaging())) {
                            ProjectArtifactMetadata pomMetadata;
                            if (artifactItem.getPomFile() != null) {
                                pomMetadata = new ProjectArtifactMetadata(artifact, artifactItem.getPomFile());
                                artifact.addMetadata((ArtifactMetadata)pomMetadata);
                            } else {
                                generatedPomFile = this.generatePomFile(artifactItem);
                                pomMetadata = new ProjectArtifactMetadata(artifact, generatedPomFile);
                                if (artifactItem.getGeneratePom().booleanValue()) {
                                    artifact.addMetadata((ArtifactMetadata)pomMetadata);
                                }
                            }
                        }
                        this.getLog().info((CharSequence)("deploying artifact to distribution repository: " + artifactItem.toString()));
                        this.artifactDeployer.deploy(artifact.getFile(), artifact, repo, this.localRepository);
                        continue;
                    }
                    this.getLog().debug((CharSequence)("configured to not deploy artifact: " + artifactItem.toString()));
                    continue;
                }
                catch (MojoFailureException e) {
                    throw e;
                }
                catch (ArtifactResolutionException e) {
                    throw new MojoExecutionException("Error occurred while attempting to resolve artifact.", (Exception)((Object)e));
                }
                catch (ArtifactNotFoundException e) {
                    throw new MojoExecutionException("Unable to find external dependency in local repository.", (Exception)((Object)e));
                }
                catch (ArtifactDeploymentException e) {
                    throw new MojoExecutionException("Deployment of external dependency failed.", (Exception)((Object)e));
                }
            }
            try {
                throw new MojoFailureException("Unable to find external dependency '" + artifactItem.getArtifactId() + "'; file not found in local repository: " + installedArtifactFile.getCanonicalPath());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to resolve dependency path in locale repository.", (Exception)e);
            }
        }
        this.getLog().info((CharSequence)"finished deploying external dependencies to distribution repository");
    }

    private ArtifactRepository getDeploymentRepository() throws MojoExecutionException, MojoFailureException {
        ArtifactRepository repo = null;
        if (repo == null) {
            repo = this.project.getDistributionManagementArtifactRepository();
        }
        if (repo == null) {
            String msg = "Deployment failed: repository element was not specified in the POM inside distributionManagement element";
            throw new MojoExecutionException(msg);
        }
        return repo;
    }

    private void failIfOffline() throws MojoFailureException {
        if (this.offline) {
            throw new MojoFailureException("Cannot deploy artifacts when Maven is in offline mode");
        }
    }
}

