/*
 * Decompiled with CFR 0.152.
 */
package com.savage7.maven.plugin.dependency;

import com.savage7.maven.plugin.dependency.AbstractExternalDependencyMojo;
import com.savage7.maven.plugin.dependency.ArtifactItem;
import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.digest.Digester;

public class InstallExternalDependencyMojo
extends AbstractExternalDependencyMojo {
    protected ArtifactRepository localRepository;
    protected ArtifactInstaller installer;
    protected Digester md5Digester;
    protected Digester sha1Digester;
    protected boolean createChecksum = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            ((AbstractExternalDependencyMojo)this).localRepository = this.localRepository;
            ((AbstractExternalDependencyMojo)this).createChecksum = this.createChecksum;
            ((AbstractExternalDependencyMojo)this).md5Digester = this.md5Digester;
            ((AbstractExternalDependencyMojo)this).sha1Digester = this.sha1Digester;
            Boolean cachedCreateChecksums = this.createChecksum;
            this.getLog().info((CharSequence)"starting to install external dependencies into local repository");
            for (ArtifactItem artifactItem : this.artifactItems) {
                this.getLog().info((CharSequence)("resolving artifact for installation: " + artifactItem.toString()));
                Artifact artifact = this.createArtifact(artifactItem);
                Boolean artifactAlreadyInstalled = this.getLocalRepoFile(artifact).exists();
                if (!artifactAlreadyInstalled.booleanValue() || artifactItem.getForce().booleanValue() || this.force.booleanValue()) {
                    File stagedArtifactFile;
                    if (artifactItem.getForce().booleanValue()) {
                        this.getLog().debug((CharSequence)("this artifact is flagged as a FORCED install: " + artifactItem.toString()));
                    }
                    if ((stagedArtifactFile = this.getFullyQualifiedArtifactFilePath(artifactItem)).exists()) {
                        if (artifactItem.hasExtractFile()) {
                            if (artifactItem.hasExtractFileChecksum()) {
                                this.verifyArtifactItemExtractFileChecksum(artifactItem, stagedArtifactFile);
                            }
                        } else {
                            this.verifyArtifactItemChecksum(artifactItem, stagedArtifactFile);
                        }
                        this.verifyArtifactItemChecksumBySonatypeLookup(artifactItem, stagedArtifactFile);
                        if (artifact != null && artifactItem.getInstall().booleanValue()) {
                            File generatedPomFile = null;
                            if (!"pom".equals(artifactItem.getPackaging())) {
                                ProjectArtifactMetadata pomMetadata;
                                if (artifactItem.getPomFile() != null) {
                                    pomMetadata = new ProjectArtifactMetadata(artifact, artifactItem.getPomFile());
                                    this.getLog().debug((CharSequence)("installing defined POM file: " + artifactItem.getPomFile()));
                                    artifact.addMetadata((ArtifactMetadata)pomMetadata);
                                } else {
                                    generatedPomFile = this.generatePomFile(artifactItem);
                                    pomMetadata = new ProjectArtifactMetadata(artifact, generatedPomFile);
                                    if (artifactItem.getGeneratePom().booleanValue()) {
                                        this.getLog().debug((CharSequence)("installing generated POM file: " + generatedPomFile.getCanonicalPath()));
                                        artifact.addMetadata((ArtifactMetadata)pomMetadata);
                                    }
                                }
                            }
                            this.getLog().info((CharSequence)("installing artifact into local repository: " + this.localRepository.getId()));
                            this.installer.install(stagedArtifactFile, artifact, this.localRepository);
                            ((AbstractExternalDependencyMojo)this).createChecksum = artifactItem.getCreateChecksum() != null ? artifactItem.getCreateChecksum().equalsIgnoreCase("true") : cachedCreateChecksums.booleanValue();
                            this.installChecksums(artifact);
                            continue;
                        }
                        this.getLog().debug((CharSequence)("configured to not install artifact: " + artifactItem.toString()));
                        continue;
                    }
                    throw new MojoFailureException("Unable to install external dependency '" + artifactItem.getArtifactId() + "'; file not found in staging path: " + stagedArtifactFile.getCanonicalPath());
                }
                this.getLog().info((CharSequence)("this aritifact already exists in the local repository; no download is needed: " + artifactItem.toString()));
            }
            this.getLog().info((CharSequence)"finished installing all external dependencies into local repository");
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

