/*
 * Decompiled with CFR 0.152.
 */
package com.savage7.maven.plugin.dependency;

import com.savage7.maven.plugin.dependency.AbstractExternalDependencyMojo;
import com.savage7.maven.plugin.dependency.ArtifactItem;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.FileUtils;

public class ResolveExternalDependencyMojo
extends AbstractExternalDependencyMojo {
    protected ArtifactRepository localRepository;
    protected ArtifactResolver artifactResolver;
    protected List remoteRepositories;
    protected ArchiverManager archiverManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            ((AbstractExternalDependencyMojo)this).localRepository = this.localRepository;
            this.getLog().info((CharSequence)"starting to resolve external dependencies");
            HashMap<URL, File> cachedDownloads = new HashMap<URL, File>();
            for (ArtifactItem artifactItem : this.artifactItems) {
                this.getLog().info((CharSequence)("attempting to resolve external artifact: " + artifactItem.toString()));
                Artifact artifact = this.createArtifact(artifactItem);
                boolean artifactResolved = this.resolveArtifactItem(artifact);
                if (!artifactResolved || artifactItem.getForce().booleanValue() || this.force.booleanValue()) {
                    File tempDownloadFile;
                    if (artifactItem.getForce().booleanValue()) {
                        this.getLog().debug((CharSequence)("this artifact is flagged as a FORCED download: " + artifactItem.toString()));
                    }
                    if (artifactItem.getDownloadUrl() == null) continue;
                    URL downloadUrl = new URL(artifactItem.getDownloadUrl());
                    if (cachedDownloads.containsKey(downloadUrl)) {
                        tempDownloadFile = (File)cachedDownloads.get(downloadUrl);
                        this.getLog().info((CharSequence)("Artifact already downloaded from URL: " + artifactItem.getDownloadUrl()));
                        this.getLog().debug((CharSequence)("Using cached download: " + tempDownloadFile.getCanonicalPath()));
                    } else {
                        tempDownloadFile = File.createTempFile(artifactItem.getLocalFile(), "." + this.getExtension(downloadUrl));
                        this.getLog().info((CharSequence)("downloading artifact from URL: " + artifactItem.getDownloadUrl()));
                        this.getLog().debug((CharSequence)("downloading artifact to temporary file: " + tempDownloadFile.getCanonicalPath()));
                        FileUtils.copyURLToFile((URL)downloadUrl, (File)tempDownloadFile);
                        this.getLog().debug((CharSequence)"caching temporary file for later");
                        cachedDownloads.put(downloadUrl, tempDownloadFile);
                    }
                    this.verifyArtifactItemChecksum(artifactItem, tempDownloadFile);
                    File artifactFile = this.getFullyQualifiedArtifactFilePath(artifactItem);
                    if (!artifactItem.hasExtractFile()) {
                        FileUtils.copyFile((File)tempDownloadFile, (File)artifactFile);
                        this.getLog().info((CharSequence)("copied downloaded artifact file to staging path: " + artifactFile.getCanonicalPath()));
                    } else {
                        UnArchiver unarchiver;
                        this.getLog().info((CharSequence)("extracting target file from downloaded compressed file: " + artifactItem.getExtractFile()));
                        try {
                            unarchiver = this.archiverManager.getUnArchiver(tempDownloadFile);
                        }
                        catch (NoSuchArchiverException e) {
                            throw new MojoExecutionException("Archive type, no unarchiver available for it", (Exception)((Object)e));
                        }
                        File parentDirectory = artifactFile.getParentFile();
                        if (parentDirectory != null && !parentDirectory.exists()) {
                            artifactFile.getParentFile().mkdirs();
                        }
                        File tempOutputDir = FileUtils.createTempFile((String)tempDownloadFile.getName(), (String)".dir", null);
                        tempOutputDir.mkdirs();
                        unarchiver.setSourceFile(tempDownloadFile);
                        unarchiver.setDestDirectory(tempOutputDir);
                        unarchiver.extract();
                        File extractedFile = new File(tempOutputDir, artifactItem.getExtractFile());
                        if (extractedFile.isFile()) {
                            FileUtils.copyFile((File)extractedFile, (File)artifactFile);
                        } else if (extractedFile.isDirectory() && artifactItem.isRepack()) {
                            Archiver archiver = this.archiverManager.getArchiver(artifactFile);
                            archiver.setDestFile(artifactFile);
                            archiver.addDirectory(extractedFile);
                            archiver.createArchive();
                        } else {
                            throw new MojoFailureException("Could not find target artifact file to extract from downloaded resouce: \r\n   groupId      : " + artifact.getGroupId() + "\r\n   artifactId   : " + artifact.getArtifactId() + "\r\n   version      : " + artifact.getVersion() + "\r\n   extractFile  : " + artifactItem.getExtractFile() + "\r\n   download URL : " + artifactItem.getDownloadUrl());
                        }
                        this.getLog().info((CharSequence)("extracted target file to staging path: " + artifactFile.getCanonicalPath()));
                    }
                    artifactItem.setLocalFile(artifactFile.getCanonicalPath());
                    this.getLog().info((CharSequence)("external artifact downloaded and staged: " + artifactItem.toString()));
                    continue;
                }
                this.getLog().info((CharSequence)("external artifact resolved in existing repository; no download needed: " + artifactItem.toString()));
            }
            for (File tempDownloadFile : cachedDownloads.values()) {
                tempDownloadFile.delete();
                this.getLog().debug((CharSequence)("deleting temporary download file: " + tempDownloadFile.getCanonicalPath()));
            }
            this.getLog().info((CharSequence)"finished resolving all external dependencies");
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private String getExtension(URL downloadUrl) {
        String path = downloadUrl.getPath();
        if (path.endsWith(".tar.gz")) {
            return "tar.gz";
        }
        if (path.endsWith(".tar.bz2")) {
            return "tar.bz2";
        }
        return FileUtils.getExtension((String)path);
    }

    protected boolean resolveArtifactItem(Artifact artifact) throws MojoFailureException {
        boolean artifactResolved = false;
        try {
            this.artifactResolver.resolve(artifact, this.remoteRepositories, this.localRepository);
            artifactResolved = true;
        }
        catch (ArtifactResolutionException e) {
            artifactResolved = false;
        }
        catch (ArtifactNotFoundException e) {
            artifactResolved = false;
        }
        return artifactResolved;
    }
}

