/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.serializer.helper.impl;

import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONString;
import com.sdicons.json.serializer.helper.MarshallHelper;
import com.sdicons.json.serializer.marshall.JSONMarshall;
import com.sdicons.json.serializer.marshall.MarshallException;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class ObjectHelper
implements MarshallHelper {
    public void renderValue(Object aObj, JSONObject aObjectElement, JSONMarshall aMarshall, HashMap aPool) throws MarshallException {
        JSONObject lElements = new JSONObject();
        aObjectElement.getValue().put("=", lElements);
        try {
            PropertyDescriptor[] lPropDesc;
            Class<?> lClass = aObj.getClass();
            for (PropertyDescriptor aLPropDesc : lPropDesc = Introspector.getBeanInfo(lClass, 1).getPropertyDescriptors()) {
                Method lReader = aLPropDesc.getReadMethod();
                Method lWriter = aLPropDesc.getWriteMethod();
                String lPropName = aLPropDesc.getName();
                if (lReader == null || lWriter == null) continue;
                lElements.getValue().put(lPropName, aMarshall.marshallImpl(lReader.invoke(aObj, new Object[0]), aPool));
            }
        }
        catch (IntrospectionException e) {
            String lMsg = "Error while introspecting JavaBean.";
            throw new MarshallException("Error while introspecting JavaBean.");
        }
        catch (IllegalAccessException e) {
            String lMsg = "Illegal access while trying to fetch a bean property (1).";
            throw new MarshallException("Illegal access while trying to fetch a bean property (1).");
        }
        catch (InvocationTargetException e) {
            String lMsg = "Illegal access while trying to fetch a bean property (2).";
            throw new MarshallException("Illegal access while trying to fetch a bean property (2).");
        }
    }

    public Object parseValue(JSONObject aObjectElement, JSONMarshall aMarshall, HashMap aPool) throws MarshallException {
        JSONMarshall.requireStringAttribute(aObjectElement, "c");
        String lBeanClassName = ((JSONString)aObjectElement.get("c")).getValue();
        String lId = null;
        try {
            JSONMarshall.requireStringAttribute(aObjectElement, "&");
            lId = ((JSONString)aObjectElement.get("&")).getValue();
        }
        catch (Exception eIgnore) {
            // empty catch block
        }
        try {
            Class<?> lBeanClass = Class.forName(lBeanClassName);
            Object lBean = lBeanClass.newInstance();
            if (lId != null) {
                aPool.put(lId, lBean);
            }
            JSONObject lProperties = (JSONObject)aObjectElement.get("=");
            for (String lPropname : lProperties.getValue().keySet()) {
                PropertyDescriptor[] lPropDesc;
                JSONObject lSubEl = (JSONObject)lProperties.get(lPropname);
                Object lProp = aMarshall.unmarshallImpl(lSubEl, aPool);
                boolean lFoundWriter = false;
                for (PropertyDescriptor aLPropDesc : lPropDesc = Introspector.getBeanInfo(lBeanClass, 1).getPropertyDescriptors()) {
                    if (!aLPropDesc.getName().equals(lPropname)) continue;
                    lFoundWriter = true;
                    Method lWriter = aLPropDesc.getWriteMethod();
                    if (lWriter == null) {
                        String lMsg = "Could not find a setter for prop: " + lPropname + " in class: " + lBeanClassName;
                        throw new MarshallException(lMsg);
                    }
                    lWriter.invoke(lBean, lProp);
                    break;
                }
                if (lFoundWriter) continue;
                String lMsg = "Could not find a setter for prop: " + lPropname + " in class: " + lBeanClassName;
                throw new MarshallException(lMsg);
            }
            return lBean;
        }
        catch (ClassNotFoundException e) {
            String lMsg = "Could not find JavaBean class: " + lBeanClassName;
            throw new MarshallException(lMsg);
        }
        catch (IllegalAccessException e) {
            String lMsg = "IllegalAccessException while trying to instantiate bean: " + lBeanClassName;
            throw new MarshallException(lMsg);
        }
        catch (InstantiationException e) {
            String lMsg = "InstantiationException while trying to instantiate bean: " + lBeanClassName;
            throw new MarshallException(lMsg);
        }
        catch (IntrospectionException e) {
            String lMsg = "IntrospectionException while trying to fill bean: " + lBeanClassName;
            throw new MarshallException(lMsg);
        }
        catch (InvocationTargetException e) {
            String lMsg = "InvocationTargetException while trying to fill bean: " + lBeanClassName;
            throw new MarshallException(lMsg);
        }
    }

    public Class getHelpedClass() {
        return Object.class;
    }
}

