/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.ProjectAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.backend.Backend;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Project;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Resources;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class JAXRSAnalyzer {
    private final Set<Path> projectPaths = new HashSet<Path>();
    private final Set<Path> classPaths = new HashSet<Path>();
    private final String projectName;
    private final String projectVersion;
    private final Path outputLocation;
    private final Backend backend;

    public JAXRSAnalyzer(Set<Path> projectPaths, Set<Path> classPaths, String projectName, String projectVersion, Backend backend, Path outputLocation) {
        Objects.requireNonNull(projectPaths);
        Objects.requireNonNull(classPaths);
        Objects.requireNonNull(projectName);
        Objects.requireNonNull(projectVersion);
        Objects.requireNonNull(backend);
        if (projectPaths.isEmpty()) {
            throw new IllegalArgumentException("At least one project path is mandatory");
        }
        this.projectPaths.addAll(projectPaths);
        this.classPaths.addAll(classPaths);
        this.projectName = projectName;
        this.projectVersion = projectVersion;
        this.outputLocation = outputLocation;
        this.backend = backend;
    }

    public void analyze() {
        Resources resources = new ProjectAnalyzer(this.classPaths.toArray(new Path[this.classPaths.size()])).analyze(this.projectPaths.toArray(new Path[this.projectPaths.size()]));
        if (resources.isEmpty()) {
            LogProvider.info("Empty JAX-RS analysis result, omitting output");
            return;
        }
        Project project = new Project(this.projectName, this.projectVersion, resources);
        String output = this.backend.render(project);
        if (this.outputLocation != null) {
            JAXRSAnalyzer.outputToFile(output, this.outputLocation);
        } else {
            System.out.println(output);
        }
    }

    private static void outputToFile(String output, Path outputLocation) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputLocation.toFile()));){
            writer.write(output);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            LogProvider.error("Could not write to the specified output location, reason: " + e.getMessage());
            LogProvider.debug(e);
        }
    }
}

