/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer;

import com.sebastian_daschner.jaxrs_analyzer.JAXRSAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.backend.Backend;
import com.sebastian_daschner.jaxrs_analyzer.backend.swagger.SwaggerBackendBuilder;
import com.sebastian_daschner.jaxrs_analyzer.backend.swagger.SwaggerScheme;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Main {
    private static final String DEFAULT_NAME = "project";
    private static final String DEFAULT_VERSION = "0.1-SNAPSHOT";
    private static final Set<Path> projectPaths = new HashSet<Path>();
    private static final Set<Path> classPaths = new HashSet<Path>();
    private static String name = "project";
    private static String version = "0.1-SNAPSHOT";
    private static BackendType backendType = BackendType.SWAGGER;
    private static String domain;
    private static Set<SwaggerScheme> swaggerSchemes;
    private static Boolean renderSwaggerTags;
    private static Integer swaggerTagsPathOffset;
    private static Path outputFileLocation;

    public static void main(String ... args) {
        if (args.length < 1) {
            Main.printUsageAndExit();
        }
        try {
            Main.extractArgs(args);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage() + '\n');
            Main.printUsageAndExit();
        }
        Main.validateArgs();
        Backend backend = Main.constructBackend();
        JAXRSAnalyzer jaxrsAnalyzer = new JAXRSAnalyzer(projectPaths, classPaths, name, version, backend, outputFileLocation);
        jaxrsAnalyzer.analyze();
    }

    private static void extractArgs(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-")) {
                    switch (args[i]) {
                        case "-b": {
                            backendType = Main.extractBackend(args[++i]);
                            break;
                        }
                        case "-cp": {
                            Main.extractClassPaths(args[++i]).forEach(classPaths::add);
                            break;
                        }
                        case "-X": {
                            LogProvider.injectDebugLogger(System.err::println);
                            break;
                        }
                        case "-n": {
                            name = args[++i];
                            break;
                        }
                        case "-v": {
                            version = args[++i];
                            break;
                        }
                        case "-d": {
                            domain = args[++i];
                            break;
                        }
                        case "-o": {
                            outputFileLocation = Paths.get(args[++i], new String[0]);
                            break;
                        }
                        case "--swaggerSchemes": {
                            swaggerSchemes = Main.extractSwaggerSchemes(args[++i]);
                            break;
                        }
                        case "--renderSwaggerTags": {
                            renderSwaggerTags = true;
                            break;
                        }
                        case "--swaggerTagsPathOffset": {
                            swaggerTagsPathOffset = Integer.valueOf(args[++i]);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown option " + args[i]);
                        }
                    }
                    continue;
                }
                Path path = Paths.get(args[i].replaceFirst("^~", System.getProperty("user.home")), new String[0]);
                if (!path.toFile().exists()) {
                    System.err.println("Location " + path.toFile() + " doesn't exist\n");
                    Main.printUsageAndExit();
                }
                projectPaths.add(path);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Please provide valid number of arguments");
        }
    }

    private static BackendType extractBackend(String name) {
        switch (name.toLowerCase()) {
            case "swagger": {
                return BackendType.SWAGGER;
            }
            case "plaintext": {
                return BackendType.PLAINTEXT;
            }
            case "asciidoc": {
                return BackendType.ASCIIDOC;
            }
        }
        throw new IllegalArgumentException("Unknown backend " + name);
    }

    private static List<Path> extractClassPaths(String classPaths) {
        List<Path> paths = Stream.of(classPaths.split(File.pathSeparator)).map(s -> s.replaceFirst("^~", System.getProperty("user.home"))).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        paths.forEach(p -> {
            if (!p.toFile().exists()) {
                throw new IllegalArgumentException("Class path " + p.toFile() + " doesn't exist");
            }
        });
        return paths;
    }

    private static Set<SwaggerScheme> extractSwaggerSchemes(String schemes) {
        return Stream.of(schemes.split(",")).map(Main::extractSwaggerScheme).collect(() -> EnumSet.noneOf(SwaggerScheme.class), Set::add, Set::addAll);
    }

    private static SwaggerScheme extractSwaggerScheme(String scheme) {
        switch (scheme.toLowerCase()) {
            case "http": {
                return SwaggerScheme.HTTP;
            }
            case "https": {
                return SwaggerScheme.HTTPS;
            }
            case "ws": {
                return SwaggerScheme.WS;
            }
            case "wss": {
                return SwaggerScheme.WSS;
            }
        }
        throw new IllegalArgumentException("Unknown swagger scheme " + scheme);
    }

    private static void validateArgs() {
        if (swaggerTagsPathOffset != null && swaggerTagsPathOffset < 0) {
            System.err.println("Please provide positive integer number for option --swaggerTagsPathOffset\n");
            Main.printUsageAndExit();
        }
        if (projectPaths.isEmpty()) {
            System.err.println("Please provide at least one project path\n");
            Main.printUsageAndExit();
        }
    }

    private static Backend constructBackend() {
        switch (backendType) {
            case SWAGGER: {
                return Main.configureSwaggerBackend();
            }
            case PLAINTEXT: {
                return Backend.plainText().build();
            }
            case ASCIIDOC: {
                return Backend.asciiDoc().build();
            }
        }
        throw new IllegalArgumentException("Unknown backend type " + (Object)((Object)backendType));
    }

    private static Backend configureSwaggerBackend() {
        SwaggerBackendBuilder builder = Backend.swagger();
        if (domain != null) {
            builder.domain(domain);
        }
        if (swaggerSchemes != null) {
            builder.schemes(swaggerSchemes);
        }
        if (renderSwaggerTags != null) {
            if (swaggerTagsPathOffset != null) {
                builder.renderTags(renderSwaggerTags, swaggerTagsPathOffset);
            } else {
                builder.renderTags(renderSwaggerTags);
            }
        }
        return builder.build();
    }

    private static void printUsageAndExit() {
        System.err.println("Usage: java -jar jaxrs-analyzer.jar [options] classPath [classPaths...]");
        System.err.println("The classPath entries may be directories or jar-files containing the classes to be analyzed\n");
        System.err.println("Following available options:\n");
        System.err.println(" -b <backend> The backend to choose: swagger (default), plaintext, asciidoc");
        System.err.println(" -cp <class path>[:class paths] Additional class paths (separated with colon) which contain classes used in the project (may be directories or jar-files)");
        System.err.println(" -X Debug enabled (enabled error debugging information)");
        System.err.println(" -n <project name> The name of the project");
        System.err.println(" -v <project version> The version of the project");
        System.err.println(" -d <project domain> The domain of the project");
        System.err.println(" -o <output file> The location of the analysis output (will be printed to standard out if omitted)");
        System.err.println("\nFollowing available backend specific options (only have effect if the corresponding backend is selected):\n");
        System.err.println(" --swaggerSchemes <scheme>[,schemes] The Swagger schemes: http (default), https, ws, wss");
        System.err.println(" --renderSwaggerTags Enables rendering of Swagger tags (default tag will be used per default)");
        System.err.println(" --swaggerTagsPathOffset <path offset> The number at which path position the Swagger tags should be extracted (0 will be used per default)");
        System.err.println("\nExample: java -jar jaxrs-analyzer.jar -b swagger -n \"My Project\" -cp ~/libs/lib1.jar:~/libs/project/bin ~/project/target/classes");
        System.exit(1);
    }

    private static enum BackendType {
        SWAGGER,
        PLAINTEXT,
        ASCIIDOC;

    }
}

