/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.JobRegistry;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.BytecodeAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.analysis.classes.JAXRSClassVisitor;
import com.sebastian_daschner.jaxrs_analyzer.analysis.results.ResultInterpreter;
import com.sebastian_daschner.jaxrs_analyzer.model.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Resources;
import com.sebastian_daschner.jaxrs_analyzer.model.results.ClassResult;
import com.sebastian_daschner.jaxrs_analyzer.utils.Pair;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;
import org.objectweb.asm.ClassReader;

public class ProjectAnalyzer {
    private final Lock lock = new ReentrantLock();
    private final Set<String> classes = new HashSet<String>();
    private final ResultInterpreter resultInterpreter = new ResultInterpreter();
    private final BytecodeAnalyzer bytecodeAnalyzer = new BytecodeAnalyzer();
    private final URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();

    public ProjectAnalyzer(java.nio.file.Path ... classPaths) {
        Stream.of(classPaths).forEach(this::addToClassPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resources analyze(java.nio.file.Path ... projectPaths) {
        this.lock.lock();
        try {
            Pair<String, ClassResult> classResultPair;
            Stream.of(projectPaths).forEach(this::addProjectPath);
            JobRegistry jobRegistry = JobRegistry.getInstance();
            HashSet<ClassResult> classResults = new HashSet<ClassResult>();
            this.classes.stream().filter(this::isJAXRSRootResource).forEach(c -> jobRegistry.analyzeResourceClass((String)c, new ClassResult()));
            while ((classResultPair = jobRegistry.nextUnhandledClass()) != null) {
                ClassResult classResult = classResultPair.getRight();
                classResults.add(classResult);
                this.analyzeClass(classResultPair.getLeft(), classResult);
                this.bytecodeAnalyzer.analyzeBytecode(classResult);
            }
            Resources resources = this.resultInterpreter.interpret(classResults);
            return resources;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isJAXRSRootResource(String className) {
        try {
            Class<?> clazz = this.urlClassLoader.loadClass(className);
            return JavaUtils.isAnnotationPresent(clazz, Path.class) || JavaUtils.isAnnotationPresent(clazz, ApplicationPath.class);
        }
        catch (ClassNotFoundException e) {
            LogProvider.error("The class " + className + " could not be loaded!");
            LogProvider.debug(e);
            return false;
        }
    }

    private void analyzeClass(String className, ClassResult classResult) {
        try {
            ClassReader classReader = new ClassReader(className);
            JAXRSClassVisitor visitor = new JAXRSClassVisitor(classResult);
            classReader.accept(visitor, 8);
        }
        catch (IOException e) {
            LogProvider.error("The class " + className + " could not be loaded!");
            LogProvider.debug(e);
        }
    }

    private void addToClassPool(java.nio.file.Path location) {
        if (!location.toFile().exists()) {
            throw new IllegalArgumentException("The location '" + location + "' does not exist!");
        }
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)this.urlClassLoader, location.toUri().toURL());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The location '" + location + "' could not be loaded to the class path!", e);
        }
    }

    private void addProjectPath(java.nio.file.Path path) {
        this.addToClassPool(path);
        if (path.toFile().isFile() && path.toString().endsWith(".jar")) {
            this.addJarClasses(path);
        } else if (path.toFile().isDirectory()) {
            this.addDirectoryClasses(path, Paths.get("", new String[0]));
        } else {
            throw new IllegalArgumentException("The project path '" + path + "' must be a jar file or a directory");
        }
    }

    private void addJarClasses(java.nio.file.Path location) {
        try (JarFile jarFile = new JarFile(location.toFile());){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String entryName = entries.nextElement().getName();
                if (!entryName.endsWith(".class")) continue;
                this.classes.add(ProjectAnalyzer.convertToQualifiedName(entryName));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read jar-file '" + location + "', reason: " + e.getMessage());
        }
    }

    private void addDirectoryClasses(java.nio.file.Path location, java.nio.file.Path subPath) {
        for (File file : location.toFile().listFiles()) {
            if (file.isDirectory()) {
                this.addDirectoryClasses(location.resolve(file.getName()), subPath.resolve(file.getName()));
                continue;
            }
            if (!file.isFile() || !file.getName().endsWith(".class")) continue;
            String classFileName = subPath.resolve(file.getName()).toString();
            this.classes.add(ProjectAnalyzer.convertToQualifiedName(classFileName));
        }
    }

    private static String convertToQualifiedName(String fileName) {
        String replacedSeparators = fileName.replace(File.separatorChar, '.');
        return replacedSeparators.substring(0, replacedSeparators.length() - ".class".length());
    }
}

