/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode;

import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.MethodContentAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation.MethodPool;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation.MethodSimulator;
import com.sebastian_daschner.jaxrs_analyzer.model.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.Element;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.HttpResponse;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonValue;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.ProjectMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.results.MethodResult;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

class ResourceMethodContentAnalyzer
extends MethodContentAnalyzer {
    private final Lock lock = new ReentrantLock();

    ResourceMethodContentAnalyzer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void analyze(MethodResult methodResult) {
        this.lock.lock();
        try {
            this.buildPackagePrefix(methodResult.getParentResource().getOriginalClass());
            List<Instruction> visitedInstructions = this.interpretRelevantInstructions(methodResult.getInstructions());
            Set<ProjectMethod> projectMethods = this.findProjectMethods(visitedInstructions);
            projectMethods.stream().forEach(MethodPool.getInstance()::addProjectMethod);
            Element returnedElement = new MethodSimulator().simulate(visitedInstructions);
            String returnType = JavaUtils.getReturnType(methodResult.getOriginalMethodSignature());
            if ("V".equals(returnType)) {
                return;
            }
            if (returnedElement == null) {
                return;
            }
            Set possibleObjects = returnedElement.getPossibleValues().stream().filter(o -> !(o instanceof HttpResponse)).collect(Collectors.toSet());
            if (!"Ljavax/ws/rs/core/Response;".equals(returnType)) {
                HttpResponse defaultResponse = new HttpResponse();
                if ("Ljava/lang/Object;".equals(returnType)) {
                    defaultResponse.getEntityTypes().addAll(returnedElement.getTypes());
                } else {
                    defaultResponse.getEntityTypes().add(returnType);
                }
                possibleObjects.stream().filter(o -> o instanceof JsonValue).map(o -> (JsonValue)o).forEach(defaultResponse.getInlineEntities()::add);
                methodResult.getResponses().add(defaultResponse);
            }
            returnedElement.getPossibleValues().stream().filter(o -> o instanceof HttpResponse).map(o -> (HttpResponse)o).forEach(methodResult.getResponses()::add);
        }
        finally {
            this.lock.unlock();
        }
    }
}

