/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.reduction;

import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.LoadInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.LoadStoreInstruction;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;

final class InstructionFinder {
    private InstructionFinder() {
        throw new UnsupportedOperationException();
    }

    static Set<Integer> findLoadIndexes(List<Instruction> instructions, Predicate<LoadInstruction> isLoadIgnored) {
        return instructions.stream().filter(i -> i.getType() == Instruction.InstructionType.LOAD).map(i -> (LoadInstruction)i).filter(i -> !isLoadIgnored.test((LoadInstruction)i)).map(LoadStoreInstruction::getNumber).collect(TreeSet::new, Set::add, Set::addAll);
    }

    static Set<Integer> findLoadStores(int index, List<Instruction> instructions) {
        Predicate<Instruction> loadStoreType = instruction -> instruction.getType() == Instruction.InstructionType.LOAD || instruction.getType() == Instruction.InstructionType.STORE;
        return InstructionFinder.find(loadStoreType.and(instruction -> ((LoadStoreInstruction)instruction).getNumber() == index), instructions);
    }

    static Set<Integer> findReturnsAndThrows(List<Instruction> instructions) {
        return InstructionFinder.find(instruction -> instruction.getType() == Instruction.InstructionType.RETURN || instruction.getType() == Instruction.InstructionType.THROW, instructions);
    }

    private static Set<Integer> find(Predicate<Instruction> predicate, List<Instruction> instructions) {
        HashSet<Integer> positions = new HashSet<Integer>();
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            if (!predicate.test(instruction)) continue;
            positions.add(i);
        }
        return positions;
    }
}

