/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation;

import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation.MethodPool;
import com.sebastian_daschner.jaxrs_analyzer.model.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.Element;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.MethodHandle;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.GetFieldInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.GetStaticInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.InvokeDynamicInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.InvokeInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.LoadInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.NewInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.PushInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.SizeChangingInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.StoreInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.Method;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class MethodSimulator {
    private final Lock lock = new ReentrantLock();
    private final MethodPool methodPool = MethodPool.getInstance();
    private final Stack<Element> runtimeStack = new Stack();
    Map<Integer, Element> localVariables = new HashMap<Integer, Element>();
    private Element returnElement;

    public Element simulate(List<Instruction> instructions) {
        this.lock.lock();
        try {
            this.returnElement = null;
            Element element = this.simulateInternal(instructions);
            return element;
        }
        finally {
            this.lock.unlock();
        }
    }

    Element simulateInternal(List<Instruction> instructions) {
        instructions.stream().forEach(this::simulate);
        return this.returnElement;
    }

    private void simulate(Instruction instruction) {
        switch (instruction.getType()) {
            case PUSH: {
                PushInstruction pushInstruction = (PushInstruction)instruction;
                this.runtimeStack.push(new Element(pushInstruction.getValueType(), pushInstruction.getValue()));
                break;
            }
            case METHOD_HANDLE: {
                this.simulateMethodHandle((InvokeDynamicInstruction)instruction);
                break;
            }
            case INVOKE: {
                this.simulateInvoke((InvokeInstruction)instruction);
                break;
            }
            case GET_FIELD: {
                this.runtimeStack.pop();
                this.runtimeStack.push(new Element(((GetFieldInstruction)instruction).getPropertyType(), new Object[0]));
                break;
            }
            case GET_STATIC: {
                GetStaticInstruction getStaticInstruction = (GetStaticInstruction)instruction;
                Object value = getStaticInstruction.getValue();
                if (value != null) {
                    this.runtimeStack.push(new Element(getStaticInstruction.getPropertyType(), value));
                    break;
                }
                this.runtimeStack.push(new Element(getStaticInstruction.getPropertyType(), new Object[0]));
                break;
            }
            case LOAD: {
                LoadInstruction loadInstruction = (LoadInstruction)instruction;
                this.runtimeStack.push(this.localVariables.getOrDefault(loadInstruction.getNumber(), new Element(loadInstruction.getVariableType(), new Object[0])));
                this.runtimeStack.peek().getTypes().add(loadInstruction.getVariableType());
                break;
            }
            case STORE: {
                this.simulateStore((StoreInstruction)instruction);
                break;
            }
            case SIZE_CHANGE: {
                this.simulateSizeChange((SizeChangingInstruction)instruction);
                break;
            }
            case NEW: {
                NewInstruction newInstruction = (NewInstruction)instruction;
                this.runtimeStack.push(new Element(JavaUtils.toType(newInstruction.getClassName()), new Object[0]));
                break;
            }
            case DUP: {
                this.runtimeStack.push(this.runtimeStack.peek());
                break;
            }
            case OTHER: {
                break;
            }
            case RETURN: {
                this.mergeReturnElement(this.runtimeStack.pop());
            }
            case THROW: {
                this.mergePossibleResponse();
                this.runtimeStack.clear();
                break;
            }
            default: {
                throw new IllegalArgumentException("Instruction without type!");
            }
        }
    }

    private void simulateMethodHandle(InvokeDynamicInstruction instruction) {
        List<Element> arguments = IntStream.range(0, instruction.getDynamicIdentifier().getParameters()).mapToObj(t -> this.runtimeStack.pop()).collect(Collectors.toList());
        Collections.reverse(arguments);
        if (!instruction.getDynamicIdentifier().isStaticMethod()) {
            arguments.remove(0);
        }
        this.runtimeStack.push(new MethodHandle(instruction.getDynamicIdentifier().getReturnType(), instruction.getIdentifier(), arguments));
    }

    private void simulateInvoke(InvokeInstruction instruction) {
        LinkedList<Element> arguments = new LinkedList<Element>();
        MethodIdentifier identifier = instruction.getIdentifier();
        IntStream.range(0, identifier.getParameters()).forEach(i -> arguments.add(this.runtimeStack.pop()));
        Collections.reverse(arguments);
        Element object = null;
        Method method = !identifier.isStaticMethod() ? ((object = this.runtimeStack.pop()) instanceof MethodHandle ? (Method)((Object)object) : this.methodPool.get(identifier)) : this.methodPool.get(identifier);
        Element returnedElement = method.invoke(object, arguments);
        if (returnedElement != null) {
            this.runtimeStack.push(returnedElement);
        } else if (!identifier.getReturnType().equals("V")) {
            this.runtimeStack.push(new Element(identifier.getReturnType(), new Object[0]));
        }
    }

    private void simulateStore(StoreInstruction instruction) {
        int index = instruction.getNumber();
        Element elementToStore = this.runtimeStack.pop();
        if (elementToStore instanceof MethodHandle) {
            this.mergeMethodHandleStore(index, (MethodHandle)elementToStore);
        } else {
            this.mergeElementStore(index, instruction.getVariableType(), elementToStore);
        }
    }

    private void mergeElementStore(int index, String type, Element element) {
        String elementType = type.equals("Ljava/lang/Object;") ? JavaUtils.determineLeastSpecificType(element.getTypes().toArray(new String[element.getTypes().size()])) : type;
        Element created = new Element(elementType, new Object[0]);
        created.merge(element);
        this.localVariables.merge(index, created, Element::merge);
    }

    private void mergeMethodHandleStore(int index, MethodHandle methodHandle) {
        this.localVariables.merge(index, new MethodHandle(methodHandle), Element::merge);
    }

    private void mergePossibleResponse() {
        if (!this.runtimeStack.isEmpty() && this.runtimeStack.peek().getTypes().contains("Ljavax/ws/rs/core/Response;")) {
            this.mergeReturnElement(this.runtimeStack.peek());
        }
    }

    private void simulateSizeChange(SizeChangingInstruction instruction) {
        IntStream.range(0, instruction.getNumberOfPops()).forEach(i -> this.runtimeStack.pop());
        IntStream.range(0, instruction.getNumberOfPushes()).forEach(i -> this.runtimeStack.push(new Element()));
    }

    private void mergeReturnElement(Element stackElement) {
        if (this.returnElement != null) {
            stackElement.merge(this.returnElement);
        }
        this.returnElement = stackElement;
    }
}

