/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.results;

import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeRepresentation;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;

class DynamicTypeAnalyzer {
    private final Map<TypeIdentifier, TypeRepresentation> typeRepresentations;

    DynamicTypeAnalyzer(Map<TypeIdentifier, TypeRepresentation> typeRepresentations) {
        this.typeRepresentations = typeRepresentations;
    }

    TypeIdentifier analyze(JsonValue jsonValue) {
        return this.analyzeInternal(jsonValue);
    }

    private TypeIdentifier analyzeInternal(JsonValue jsonValue) {
        switch (jsonValue.getValueType()) {
            case ARRAY: {
                return this.analyzeInternal((JsonArray)jsonValue);
            }
            case OBJECT: {
                return this.analyzeInternal((JsonObject)jsonValue);
            }
            case STRING: {
                return TypeIdentifier.ofType("Ljava/lang/String;");
            }
            case NUMBER: {
                return TypeIdentifier.ofType("Ljava/lang/Double;");
            }
            case TRUE: 
            case FALSE: {
                return TypeIdentifier.ofType("Z");
            }
            case NULL: {
                return TypeIdentifier.ofType("Ljava/lang/Object;");
            }
        }
        throw new IllegalArgumentException("Unknown JSON value type provided");
    }

    private TypeIdentifier analyzeInternal(JsonArray jsonArray) {
        TypeIdentifier containedIdentifier = jsonArray.isEmpty() ? TypeIdentifier.ofType("Ljava/lang/Object;") : this.analyzeInternal((JsonValue)jsonArray.get(0));
        TypeRepresentation containedRepresentation = this.typeRepresentations.getOrDefault(containedIdentifier, TypeRepresentation.ofConcrete(containedIdentifier));
        TypeIdentifier existingCollection = this.findExistingCollection(containedRepresentation);
        if (existingCollection != null) {
            return existingCollection;
        }
        TypeIdentifier identifier = TypeIdentifier.ofDynamic();
        this.typeRepresentations.put(identifier, TypeRepresentation.ofCollection(identifier, containedRepresentation));
        return identifier;
    }

    private TypeIdentifier analyzeInternal(JsonObject jsonObject) {
        HashMap properties = jsonObject.entrySet().stream().collect(HashMap::new, (m, v) -> m.put(v.getKey(), this.analyze((JsonValue)v.getValue())), Map::putAll);
        TypeIdentifier existing = this.findExistingType(properties);
        if (existing != null) {
            return existing;
        }
        TypeIdentifier identifier = TypeIdentifier.ofDynamic();
        this.typeRepresentations.put(identifier, TypeRepresentation.ofConcrete(identifier, properties));
        return identifier;
    }

    private TypeIdentifier findExistingCollection(TypeRepresentation containedRepresentation) {
        return this.typeRepresentations.entrySet().stream().filter(e -> e.getValue() instanceof TypeRepresentation.CollectionTypeRepresentation).filter(e -> ((TypeIdentifier)e.getKey()).getType().equals("Ljavax/json/Json;")).filter(e -> ((TypeRepresentation.CollectionTypeRepresentation)e.getValue()).contentEquals(containedRepresentation)).map(Map.Entry::getKey).findAny().orElse(null);
    }

    private TypeIdentifier findExistingType(HashMap<String, TypeIdentifier> properties) {
        return this.typeRepresentations.entrySet().stream().filter(e -> e.getValue() instanceof TypeRepresentation.ConcreteTypeRepresentation).filter(e -> ((TypeIdentifier)e.getKey()).getType().equals("Ljavax/json/Json;")).filter(e -> ((TypeRepresentation.ConcreteTypeRepresentation)e.getValue()).contentEquals(properties)).map(Map.Entry::getKey).findAny().orElse(null);
    }
}

