/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.results;

import com.sebastian_daschner.jaxrs_analyzer.model.results.ClassResult;
import com.sebastian_daschner.jaxrs_analyzer.model.results.MethodResult;
import com.sebastian_daschner.jaxrs_analyzer.utils.StringUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

final class PathNormalizer {
    private PathNormalizer() {
        throw new UnsupportedOperationException();
    }

    static String getApplicationPath(Set<ClassResult> classResults) {
        return classResults.stream().map(ClassResult::getApplicationPath).filter(Objects::nonNull).map(PathNormalizer::normalize).findAny().orElse("");
    }

    static String getPath(MethodResult methodResult) {
        List<String> paths = PathNormalizer.determinePaths(methodResult);
        return paths.stream().map(PathNormalizer::normalize).collect(Collectors.joining("/"));
    }

    private static List<String> determinePaths(MethodResult methodResult) {
        LinkedList<String> paths;
        block1: {
            ClassResult parentClass;
            paths = new LinkedList<String>();
            MethodResult currentMethod = methodResult;
            do {
                PathNormalizer.addNonBlank(currentMethod.getPath(), paths);
                parentClass = currentMethod.getParentResource();
                if (parentClass == null) break block1;
            } while ((currentMethod = parentClass.getParentSubResourceLocator()) != null);
            PathNormalizer.addNonBlank(parentClass.getResourcePath(), paths);
        }
        Collections.reverse(paths);
        return paths;
    }

    private static void addNonBlank(String string, List<String> strings) {
        if (!StringUtils.isBlank(string)) {
            strings.add(string);
        }
    }

    private static String normalize(String path) {
        String normalized = path;
        if (normalized.endsWith("/")) {
            normalized = normalized.substring(0, normalized.length() - 1);
        }
        if (normalized.startsWith("/")) {
            normalized = normalized.substring(1);
        }
        return normalized;
    }
}

