/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.results;

import com.sebastian_daschner.jaxrs_analyzer.analysis.results.DynamicTypeAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.analysis.results.JavaTypeAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.analysis.results.JsonMapper;
import com.sebastian_daschner.jaxrs_analyzer.analysis.results.PathNormalizer;
import com.sebastian_daschner.jaxrs_analyzer.analysis.results.StringParameterResolver;
import com.sebastian_daschner.jaxrs_analyzer.model.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.HttpResponse;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.MethodParameter;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.ResourceMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Resources;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Response;
import com.sebastian_daschner.jaxrs_analyzer.model.results.ClassResult;
import com.sebastian_daschner.jaxrs_analyzer.model.results.MethodResult;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.core.Response;

public class ResultInterpreter {
    private JavaTypeAnalyzer javaTypeAnalyzer;
    private Resources resources;
    private DynamicTypeAnalyzer dynamicTypeAnalyzer;
    private StringParameterResolver stringParameterResolver;

    public Resources interpret(Set<ClassResult> classResults) {
        this.resources = new Resources();
        this.resources.setBasePath(PathNormalizer.getApplicationPath(classResults));
        this.javaTypeAnalyzer = new JavaTypeAnalyzer(this.resources.getTypeRepresentations());
        this.dynamicTypeAnalyzer = new DynamicTypeAnalyzer(this.resources.getTypeRepresentations());
        this.stringParameterResolver = new StringParameterResolver(this.resources.getTypeRepresentations(), this.javaTypeAnalyzer);
        classResults.stream().filter(c -> c.getResourcePath() != null).forEach(this::interpretClassResult);
        return this.resources;
    }

    private void interpretClassResult(ClassResult classResult) {
        classResult.getMethods().stream().forEach(m -> this.interpretMethodResult((MethodResult)m, classResult));
    }

    private void interpretMethodResult(MethodResult methodResult, ClassResult classResult) {
        if (methodResult.getSubResource() != null) {
            this.interpretClassResult(methodResult.getSubResource());
            return;
        }
        String path = PathNormalizer.getPath(methodResult);
        ResourceMethod resourceMethod = this.interpretResourceMethod(methodResult, classResult);
        this.resources.addMethod(path, resourceMethod);
    }

    private ResourceMethod interpretResourceMethod(MethodResult methodResult, ClassResult classResult) {
        ResourceMethod resourceMethod = new ResourceMethod(methodResult.getHttpMethod());
        this.updateMethodParameters(resourceMethod.getMethodParameters(), classResult.getClassFields());
        this.updateMethodParameters(resourceMethod.getMethodParameters(), methodResult.getMethodParameters());
        this.stringParameterResolver.replaceParametersTypes(resourceMethod.getMethodParameters());
        if (methodResult.getRequestBodyType() != null) {
            resourceMethod.setRequestBody(this.javaTypeAnalyzer.analyze(methodResult.getRequestBodyType()));
        }
        this.addDefaultResponses(methodResult);
        methodResult.getResponses().stream().forEach(r -> this.interpretResponse((HttpResponse)r, resourceMethod));
        this.addMediaTypes(methodResult, classResult, resourceMethod);
        return resourceMethod;
    }

    private void updateMethodParameters(Set<MethodParameter> parameters, Set<MethodParameter> additional) {
        additional.stream().forEach(a -> {
            Optional<MethodParameter> existingParameter = parameters.stream().filter(p -> p.getName().equals(a.getName())).findAny();
            existingParameter.ifPresent(parameters::remove);
            parameters.add((MethodParameter)a);
        });
    }

    private void addDefaultResponses(MethodResult methodResult) {
        if (methodResult.getResponses().isEmpty()) {
            HttpResponse httpResponse = new HttpResponse();
            httpResponse.getStatuses().add(Response.Status.NO_CONTENT.getStatusCode());
            methodResult.getResponses().add(httpResponse);
            return;
        }
        methodResult.getResponses().stream().filter(r -> r.getStatuses().isEmpty()).forEach(r -> r.getStatuses().add(Response.Status.OK.getStatusCode()));
    }

    private void interpretResponse(HttpResponse httpResponse, ResourceMethod method) {
        method.getResponseMediaTypes().addAll(httpResponse.getContentTypes());
        httpResponse.getStatuses().stream().forEach(s -> {
            Response response = httpResponse.getInlineEntities().stream().findAny().map(JsonMapper::map).map(this.dynamicTypeAnalyzer::analyze).map(Response::new).orElse(null);
            if (response == null) {
                response = httpResponse.getEntityTypes().isEmpty() ? new Response() : new Response(this.javaTypeAnalyzer.analyze(JavaUtils.determineMostSpecificType((String[])httpResponse.getEntityTypes().stream().toArray(String[]::new))));
            }
            response.getHeaders().addAll(httpResponse.getHeaders());
            method.getResponses().put((Integer)s, response);
        });
    }

    private void addMediaTypes(MethodResult methodResult, ClassResult classResult, ResourceMethod resourceMethod) {
        resourceMethod.getRequestMediaTypes().addAll(methodResult.getRequestMediaTypes());
        if (resourceMethod.getRequestMediaTypes().isEmpty()) {
            resourceMethod.getRequestMediaTypes().addAll(classResult.getRequestMediaTypes());
        }
        if (resourceMethod.getResponseMediaTypes().isEmpty()) {
            resourceMethod.getResponseMediaTypes().addAll(methodResult.getResponseMediaTypes());
        }
        if (resourceMethod.getResponseMediaTypes().isEmpty()) {
            resourceMethod.getResponseMediaTypes().addAll(classResult.getResponseMediaTypes());
        }
    }
}

