/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.backend.plaintext;

import com.sebastian_daschner.jaxrs_analyzer.backend.Backend;
import com.sebastian_daschner.jaxrs_analyzer.backend.ComparatorUtils;
import com.sebastian_daschner.jaxrs_analyzer.backend.JsonRepresentationAppender;
import com.sebastian_daschner.jaxrs_analyzer.model.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.MethodParameter;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.ParameterType;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Project;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.ResourceMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Resources;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Response;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeRepresentation;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeRepresentationVisitor;
import com.sebastian_daschner.jaxrs_analyzer.utils.StringUtils;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

class PlainTextBackend
implements Backend {
    private static final String NAME = "Plain text";
    private static final String REST_HEADER = "REST resources of ";
    private static final String TYPE_WILDCARD = "*/*";
    private final Lock lock = new ReentrantLock();
    private StringBuilder builder;
    private Resources resources;
    private String projectName;
    private String projectVersion;
    private TypeRepresentationVisitor visitor;

    PlainTextBackend() {
    }

    @Override
    public String render(Project project) {
        this.lock.lock();
        try {
            this.builder = new StringBuilder();
            this.resources = project.getResources();
            this.projectName = project.getName();
            this.projectVersion = project.getVersion();
            this.visitor = new JsonRepresentationAppender(this.builder, this.resources.getTypeRepresentations());
            String string = this.renderInternal();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    private String renderInternal() {
        this.appendHeader();
        this.resources.getResources().stream().sorted().forEach(this::appendResource);
        return this.builder.toString();
    }

    private void appendHeader() {
        this.builder.append(REST_HEADER).append(this.projectName).append(":\n").append(this.projectVersion).append("\n\n");
    }

    private void appendResource(String resource) {
        this.resources.getMethods(resource).stream().sorted(Comparator.comparing(ResourceMethod::getMethod)).forEach(resourceMethod -> {
            this.appendMethod(this.resources.getBasePath(), resource, (ResourceMethod)resourceMethod);
            this.appendRequest((ResourceMethod)resourceMethod);
            this.appendResponse((ResourceMethod)resourceMethod);
            this.appendResourceEnd();
        });
    }

    private void appendMethod(String baseUri, String resource, ResourceMethod resourceMethod) {
        this.builder.append((Object)resourceMethod.getMethod()).append(' ');
        if (!StringUtils.isBlank(baseUri)) {
            this.builder.append(baseUri).append('/');
        }
        this.builder.append(resource).append(":\n");
    }

    private void appendRequest(ResourceMethod resourceMethod) {
        this.builder.append(" Request:\n");
        if (resourceMethod.getRequestBody() != null) {
            this.builder.append("  Content-Type: ");
            this.builder.append(resourceMethod.getRequestMediaTypes().isEmpty() ? TYPE_WILDCARD : PlainTextBackend.toString(resourceMethod.getRequestMediaTypes()));
            this.builder.append('\n');
            this.builder.append("  Request Body: ").append(this.toTypeOrCollection(resourceMethod.getRequestBody())).append('\n');
            Optional.ofNullable(this.resources.getTypeRepresentations().get(resourceMethod.getRequestBody())).ifPresent(r -> {
                this.builder.append("   ");
                r.accept(this.visitor);
                this.builder.append('\n');
            });
        } else {
            this.builder.append("  No body\n");
        }
        Set<MethodParameter> parameters = resourceMethod.getMethodParameters();
        this.appendParams("  Path Param: ", parameters, ParameterType.PATH);
        this.appendParams("  Query Param: ", parameters, ParameterType.QUERY);
        this.appendParams("  Form Param: ", parameters, ParameterType.FORM);
        this.appendParams("  Header Param: ", parameters, ParameterType.HEADER);
        this.appendParams("  Cookie Param: ", parameters, ParameterType.COOKIE);
        this.appendParams("  Matrix Param: ", parameters, ParameterType.MATRIX);
        this.builder.append('\n');
    }

    private void appendParams(String name, Set<MethodParameter> parameters, ParameterType parameterType) {
        parameters.stream().filter(p -> p.getParameterType() == parameterType).sorted(ComparatorUtils.parameterComparator()).forEach(p -> this.builder.append(name).append(p.getName()).append(", ").append(JavaUtils.toReadableType(p.getType().getType())).append('\n'));
    }

    private void appendResponse(ResourceMethod resourceMethod) {
        this.builder.append(" Response:\n");
        this.builder.append("  Content-Type: ");
        this.builder.append(resourceMethod.getResponseMediaTypes().isEmpty() ? TYPE_WILDCARD : PlainTextBackend.toString(resourceMethod.getResponseMediaTypes()));
        this.builder.append('\n');
        resourceMethod.getResponses().entrySet().stream().sorted(ComparatorUtils.mapKeyComparator()).forEach(e -> {
            this.builder.append("  Status Codes: ").append(e.getKey()).append('\n');
            Response response = (Response)e.getValue();
            if (!response.getHeaders().isEmpty()) {
                this.builder.append("   Header: ").append(response.getHeaders().stream().sorted().collect(Collectors.joining(", ")));
                this.builder.append('\n');
            }
            if (response.getResponseBody() != null) {
                this.builder.append("   Response Body: ").append(this.toTypeOrCollection(response.getResponseBody())).append('\n');
                Optional.ofNullable(this.resources.getTypeRepresentations().get(response.getResponseBody())).ifPresent(r -> {
                    this.builder.append("    ");
                    r.accept(this.visitor);
                    this.builder.append('\n');
                });
            }
            this.builder.append('\n');
        });
    }

    private void appendResourceEnd() {
        this.builder.append("\n");
    }

    private String toTypeOrCollection(TypeIdentifier type) {
        TypeRepresentation representation = this.resources.getTypeRepresentations().get(type);
        if (representation != null && !representation.getComponentType().equals(type) && !type.getType().equals("Ljavax/json/Json;")) {
            return "Collection of " + JavaUtils.toReadableType(representation.getComponentType().getType());
        }
        return JavaUtils.toReadableType(type.getType());
    }

    private static String toString(Set<String> set) {
        return set.stream().sorted().map(Object::toString).collect(Collectors.joining(", "));
    }

    @Override
    public String getName() {
        return NAME;
    }
}

