/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.instructions;

import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;

public class InvokeInstruction
implements Instruction {
    private final MethodIdentifier identifier;

    public InvokeInstruction(MethodIdentifier identifier) {
        this.identifier = identifier;
    }

    @Override
    public int getStackSizeDifference() {
        int difference;
        int n = difference = "V".equals(this.identifier.getReturnType()) ? -1 : 0;
        if (this.identifier.isStaticMethod()) {
            ++difference;
        }
        return difference -= this.identifier.getParameters();
    }

    @Override
    public Instruction.InstructionType getType() {
        return Instruction.InstructionType.INVOKE;
    }

    public MethodIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvokeInstruction that = (InvokeInstruction)o;
        return this.identifier.equals(that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public String toString() {
        return "InvokeInstruction{identifier=" + this.identifier + '}';
    }
}

