/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.instructions;

import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import com.sebastian_daschner.jaxrs_analyzer.utils.StringUtils;
import java.util.Objects;

public abstract class LoadStoreInstruction
implements Instruction {
    private static final String UNKNOWN_VARIABLE_NAME_PREFIX = "variable$";
    private final int number;
    private final String variableType;
    private final String name;

    protected LoadStoreInstruction(int number, String variableType) {
        Objects.requireNonNull(variableType);
        this.number = number;
        this.variableType = variableType;
        this.name = UNKNOWN_VARIABLE_NAME_PREFIX + number;
    }

    protected LoadStoreInstruction(int number, String variableType, String name) {
        Objects.requireNonNull(variableType);
        StringUtils.requireNonBlank(name);
        this.number = number;
        this.variableType = variableType;
        this.name = name;
    }

    public int getNumber() {
        return this.number;
    }

    public String getVariableType() {
        return this.variableType;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadStoreInstruction that = (LoadStoreInstruction)o;
        if (this.number != that.number) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.variableType.equals(that.variableType)) {
            return false;
        }
        if (this.getStackSizeDifference() != that.getStackSizeDifference()) {
            return false;
        }
        return this.getType() == that.getType();
    }

    public int hashCode() {
        int result = this.number;
        result = 31 * result + this.getStackSizeDifference();
        result = 31 * result + (this.getType() != null ? this.getType().ordinal() : 0);
        result = 31 * result + this.variableType.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return "LoadStoreInstruction{type='" + (Object)((Object)this.getType()) + '\'' + ", number=" + this.number + '\'' + ", variableType=" + this.variableType + '\'' + ", name=" + this.name + '}';
    }
}

