/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.instructions;

import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import org.objectweb.asm.Label;

public class LoadStoreInstructionPlaceholder
implements Instruction {
    private final Instruction.InstructionType type;
    private final int number;
    private final Label label;

    public LoadStoreInstructionPlaceholder(Instruction.InstructionType type, int number, Label label) {
        if (type != Instruction.InstructionType.LOAD_PLACEHOLDER && type != Instruction.InstructionType.STORE_PLACEHOLDER) {
            throw new IllegalArgumentException("Only LOAD and STORE placeholders allowed!");
        }
        this.type = type;
        this.number = number;
        this.label = label;
    }

    public int getNumber() {
        return this.number;
    }

    public Label getLabel() {
        return this.label;
    }

    @Override
    public int getStackSizeDifference() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Instruction.InstructionType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadStoreInstructionPlaceholder that = (LoadStoreInstructionPlaceholder)o;
        if (this.number != that.number) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return this.label != null ? this.label.equals(that.label) : that.label == null;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.number;
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        return result;
    }
}

