/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.methods;

import com.sebastian_daschner.jaxrs_analyzer.model.JavaUtils;
import java.util.Objects;
import java.util.stream.Stream;

public class MethodIdentifier {
    private final String containingClass;
    private final String methodName;
    private final String returnType;
    private final boolean staticMethod;
    private final String signature;
    private final int parameters;

    private MethodIdentifier(String containingClass, String methodName, String returnType, boolean staticMethod, String signature, int parameters) {
        Objects.requireNonNull(containingClass);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(returnType);
        Objects.requireNonNull(signature);
        this.containingClass = containingClass;
        this.methodName = methodName;
        this.returnType = returnType;
        this.staticMethod = staticMethod;
        this.signature = signature;
        this.parameters = parameters;
    }

    public String getContainingClass() {
        return this.containingClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getParameters() {
        return this.parameters;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean isStaticMethod() {
        return this.staticMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodIdentifier that = (MethodIdentifier)o;
        if (this.staticMethod != that.staticMethod) {
            return false;
        }
        if (!this.containingClass.equals(that.containingClass)) {
            return false;
        }
        if (!this.methodName.equals(that.methodName)) {
            return false;
        }
        return this.signature.equals(that.signature);
    }

    public int hashCode() {
        int result = this.containingClass.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + this.returnType.hashCode();
        result = 31 * result + (this.staticMethod ? 1 : 0);
        result = 31 * result + this.signature.hashCode();
        result = 31 * result + this.parameters;
        return result;
    }

    public String toString() {
        return "MethodIdentifier{containingClass='" + this.containingClass + '\'' + ", methodName='" + this.methodName + '\'' + ", returnType='" + this.returnType + '\'' + ", staticMethod=" + this.staticMethod + ", signature='" + this.signature + '\'' + ", parameters=" + this.parameters + '}';
    }

    public static MethodIdentifier of(String containingClass, String methodName, String signature, boolean staticMethod) {
        String returnType = JavaUtils.getReturnType(signature);
        int parameters = JavaUtils.getParameters(signature).size();
        return new MethodIdentifier(containingClass, methodName, returnType, staticMethod, signature, parameters);
    }

    public static MethodIdentifier ofNonStatic(String containingClass, String methodName, String returnType, String ... parameterTypes) {
        return MethodIdentifier.of(containingClass, methodName, returnType, false, parameterTypes);
    }

    public static MethodIdentifier ofStatic(String containingClass, String methodName, String returnType, String ... parameterTypes) {
        return MethodIdentifier.of(containingClass, methodName, returnType, true, parameterTypes);
    }

    private static MethodIdentifier of(String containingClass, String methodName, String returnType, boolean staticMethod, String[] parameterTypes) {
        Objects.requireNonNull(parameterTypes);
        StringBuilder builder = new StringBuilder("(");
        Stream.of(parameterTypes).forEach(builder::append);
        String signature = builder.append(')').append(returnType).toString();
        int parameters = parameterTypes.length;
        return new MethodIdentifier(containingClass, methodName, returnType, staticMethod, signature, parameters);
    }
}

