/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.classes;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.classes.annotation.ConsumesAnnotationVisitor;
import com.sebastian_daschner.jaxrs_analyzer.analysis.classes.annotation.DefaultValueAnnotationVisitor;
import com.sebastian_daschner.jaxrs_analyzer.analysis.classes.annotation.ParamAnnotationVisitor;
import com.sebastian_daschner.jaxrs_analyzer.analysis.classes.annotation.PathAnnotationVisitor;
import com.sebastian_daschner.jaxrs_analyzer.analysis.classes.annotation.ProducesAnnotationVisitor;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.HttpMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.MethodParameter;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.ParameterType;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.results.MethodResult;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;

class JAXRSAnnotatedSuperMethodVisitor
extends MethodVisitor {
    private final MethodResult methodResult;
    private final List<String> parameterTypes;
    private final Map<Integer, MethodParameter> methodParameters;
    private final BitSet annotatedParameters;

    JAXRSAnnotatedSuperMethodVisitor(MethodResult methodResult) {
        super(327680);
        this.methodResult = methodResult;
        this.parameterTypes = methodResult.getOriginalMethodSignature().getParameters();
        this.annotatedParameters = new BitSet(this.parameterTypes.size());
        this.methodParameters = new HashMap<Integer, MethodParameter>();
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        switch (desc) {
            case "Ljavax/ws/rs/GET;": {
                this.methodResult.setHttpMethod(HttpMethod.GET);
                break;
            }
            case "Ljavax/ws/rs/POST;": {
                this.methodResult.setHttpMethod(HttpMethod.POST);
                break;
            }
            case "Ljavax/ws/rs/PUT;": {
                this.methodResult.setHttpMethod(HttpMethod.PUT);
                break;
            }
            case "Ljavax/ws/rs/DELETE;": {
                this.methodResult.setHttpMethod(HttpMethod.DELETE);
                break;
            }
            case "Ljavax/ws/rs/HEAD;": {
                this.methodResult.setHttpMethod(HttpMethod.HEAD);
                break;
            }
            case "Ljavax/ws/rs/OPTIONS;": {
                this.methodResult.setHttpMethod(HttpMethod.OPTIONS);
                break;
            }
            case "Ljavax/ws/rs/Path;": {
                return new PathAnnotationVisitor(this.methodResult);
            }
            case "Ljavax/ws/rs/Consumes;": {
                return new ConsumesAnnotationVisitor(this.methodResult);
            }
            case "Ljavax/ws/rs/Produces;": {
                return new ProducesAnnotationVisitor(this.methodResult);
            }
        }
        return null;
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int index, String annotationDesc, boolean visible) {
        switch (annotationDesc) {
            case "Ljavax/ws/rs/PathParam;": {
                return this.paramAnnotationVisitor(index, ParameterType.PATH);
            }
            case "Ljavax/ws/rs/QueryParam;": {
                return this.paramAnnotationVisitor(index, ParameterType.QUERY);
            }
            case "Ljavax/ws/rs/HeaderParam;": {
                return this.paramAnnotationVisitor(index, ParameterType.HEADER);
            }
            case "Ljavax/ws/rs/FormParam;": {
                return this.paramAnnotationVisitor(index, ParameterType.FORM);
            }
            case "Ljavax/ws/rs/CookieParam;": {
                return this.paramAnnotationVisitor(index, ParameterType.COOKIE);
            }
            case "Ljavax/ws/rs/MatrixParam;": {
                return this.paramAnnotationVisitor(index, ParameterType.MATRIX);
            }
            case "Ljavax/ws/rs/DefaultValue;": {
                return this.defaultAnnotationVisitor(index);
            }
            case "Ljavax/ws/rs/container/Suspended;": {
                LogProvider.debug("Handling of " + annotationDesc + " not yet implemented");
            }
            case "Ljavax/ws/rs/core/Context;": {
                this.annotatedParameters.set(index);
            }
        }
        return null;
    }

    private AnnotationVisitor paramAnnotationVisitor(int index, ParameterType parameterType) {
        this.annotatedParameters.set(index);
        String type = this.parameterTypes.get(index);
        MethodParameter methodParameter = this.methodParameters.get(index);
        if (methodParameter == null) {
            methodParameter = new MethodParameter(TypeIdentifier.ofType(type), parameterType);
            this.methodParameters.put(index, methodParameter);
        } else {
            methodParameter.setParameterType(parameterType);
        }
        return new ParamAnnotationVisitor(methodParameter);
    }

    private AnnotationVisitor defaultAnnotationVisitor(int index) {
        String type = this.parameterTypes.get(index);
        MethodParameter methodParameter = this.methodParameters.get(index);
        if (methodParameter == null) {
            methodParameter = new MethodParameter(TypeIdentifier.ofType(type));
            this.methodParameters.put(index, methodParameter);
        }
        return new DefaultValueAnnotationVisitor(methodParameter);
    }

    @Override
    public void visitEnd() {
        if (this.annotatedParameters.cardinality() != this.parameterTypes.size()) {
            String requestBodyType = this.parameterTypes.get(this.annotatedParameters.nextClearBit(0));
            this.methodResult.setRequestBodyType(requestBodyType);
        }
        this.methodResult.getMethodParameters().addAll(this.methodParameters.values());
    }
}

