/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.classes;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.classes.JAXRSAnnotatedSuperMethodClassVisitor;
import com.sebastian_daschner.jaxrs_analyzer.analysis.classes.JAXRSFieldVisitor;
import com.sebastian_daschner.jaxrs_analyzer.analysis.classes.JAXRSMethodVisitor;
import com.sebastian_daschner.jaxrs_analyzer.analysis.classes.annotation.ApplicationPathAnnotationVisitor;
import com.sebastian_daschner.jaxrs_analyzer.analysis.classes.annotation.ConsumesAnnotationVisitor;
import com.sebastian_daschner.jaxrs_analyzer.analysis.classes.annotation.PathAnnotationVisitor;
import com.sebastian_daschner.jaxrs_analyzer.analysis.classes.annotation.ProducesAnnotationVisitor;
import com.sebastian_daschner.jaxrs_analyzer.model.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.results.ClassResult;
import com.sebastian_daschner.jaxrs_analyzer.model.results.MethodResult;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Stream;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class JAXRSClassVisitor
extends ClassVisitor {
    private static final Class<? extends Annotation>[] RELEVANT_METHOD_ANNOTATIONS = new Class[]{Path.class, GET.class, PUT.class, POST.class, DELETE.class, OPTIONS.class, HEAD.class};
    private final ClassResult classResult;

    public JAXRSClassVisitor(ClassResult classResult) {
        super(327680);
        this.classResult = classResult;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classResult.setOriginalClass(name);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        switch (desc) {
            case "Ljavax/ws/rs/Path;": {
                return new PathAnnotationVisitor(this.classResult);
            }
            case "Ljavax/ws/rs/ApplicationPath;": {
                return new ApplicationPathAnnotationVisitor(this.classResult);
            }
            case "Ljavax/ws/rs/Consumes;": {
                return new ConsumesAnnotationVisitor(this.classResult);
            }
            case "Ljavax/ws/rs/Produces;": {
                return new ProducesAnnotationVisitor(this.classResult);
            }
        }
        return null;
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if ((access & 8) == 0) {
            return new JAXRSFieldVisitor(this.classResult, desc, signature);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        boolean legalModifiers = (access & 0x1000 | access & 8 | access & 0x100) == 0;
        String methodSignature = signature == null ? desc : signature;
        MethodIdentifier identifier = MethodIdentifier.of(this.classResult.getOriginalClass(), name, methodSignature, false);
        if (legalModifiers && !"<init>".equals(name)) {
            MethodResult methodResult = new MethodResult();
            if (JAXRSClassVisitor.hasJAXRSAnnotations(this.classResult.getOriginalClass(), name, methodSignature)) {
                return new JAXRSMethodVisitor(identifier, this.classResult, methodResult, true);
            }
            Method annotatedSuperMethod = JAXRSClassVisitor.searchAnnotatedSuperMethod(this.classResult.getOriginalClass(), name, methodSignature);
            if (annotatedSuperMethod != null) {
                try {
                    JAXRSMethodVisitor jAXRSMethodVisitor = new JAXRSMethodVisitor(identifier, this.classResult, methodResult, false);
                    return jAXRSMethodVisitor;
                }
                finally {
                    this.classResult.getMethods().stream().filter(m -> m.equals(methodResult)).findAny().ifPresent(m -> this.visitJAXRSSuperMethod(annotatedSuperMethod, (MethodResult)m));
                }
            }
        }
        return null;
    }

    private static boolean hasJAXRSAnnotations(String className, String methodName, String signature) {
        Method method = JavaUtils.findMethod(className, methodName, signature);
        return method != null && JAXRSClassVisitor.hasJAXRSAnnotations(method);
    }

    private static Method searchAnnotatedSuperMethod(String className, String methodName, String methodSignature) {
        List<Class<?>> superTypes = JAXRSClassVisitor.determineSuperTypes(className);
        return superTypes.stream().map(c -> {
            Method superAnnotatedMethod = JavaUtils.findMethod(c, methodName, methodSignature);
            if (superAnnotatedMethod != null && JAXRSClassVisitor.hasJAXRSAnnotations(superAnnotatedMethod)) {
                return superAnnotatedMethod;
            }
            return null;
        }).filter(Objects::nonNull).findAny().orElse(null);
    }

    private static List<Class<?>> determineSuperTypes(String className) {
        Class loadedClass = JavaUtils.loadClassFromName(className);
        if (loadedClass == null) {
            return Collections.emptyList();
        }
        ArrayList superClasses = new ArrayList();
        LinkedBlockingQueue classesToCheck = new LinkedBlockingQueue();
        Class currentClass = loadedClass;
        do {
            if (currentClass.getSuperclass() != null && Object.class != currentClass.getSuperclass()) {
                classesToCheck.add(currentClass.getSuperclass());
            }
            Stream.of(currentClass.getInterfaces()).forEach(classesToCheck::add);
            if (currentClass == loadedClass) continue;
            superClasses.add(currentClass);
        } while ((currentClass = (Class)classesToCheck.poll()) != null);
        return superClasses;
    }

    private static boolean hasJAXRSAnnotations(Method method) {
        for (Annotation annotation : method.getDeclaredAnnotations()) {
            if (Stream.of(RELEVANT_METHOD_ANNOTATIONS).map(a -> JavaUtils.getAnnotation(method, a)).filter(Objects::nonNull).anyMatch(a -> a.getClass().isAssignableFrom(annotation.getClass()))) {
                return true;
            }
            if (!JavaUtils.isAnnotationPresent(annotation.getClass(), HttpMethod.class)) continue;
            return true;
        }
        return false;
    }

    private void visitJAXRSSuperMethod(Method method, MethodResult methodResult) {
        try {
            ClassReader classReader = new ClassReader(method.getDeclaringClass().getCanonicalName());
            JAXRSAnnotatedSuperMethodClassVisitor visitor = new JAXRSAnnotatedSuperMethodClassVisitor(methodResult, method);
            classReader.accept(visitor, 8);
        }
        catch (IOException e) {
            LogProvider.error("Could not analyze JAX-RS super annotated method " + method);
            LogProvider.debug(e);
        }
    }
}

