/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.classes;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.classes.ProjectMethodVisitor;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.results.MethodResult;
import java.io.IOException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class ProjectMethodClassVisitor
extends ClassVisitor {
    private final MethodResult methodResult;
    private final MethodIdentifier identifier;
    private boolean methodFound;
    private String superName;

    public ProjectMethodClassVisitor(MethodResult methodResult, MethodIdentifier identifier) {
        super(327680);
        this.methodResult = methodResult;
        this.identifier = identifier;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.superName = superName;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        boolean legalModifiers = (access & 0x400 | access & 0x100) == 0;
        String methodSignature = this.identifier.getSignature();
        if (legalModifiers && this.identifier.getMethodName().equals(name) && (methodSignature.equals(desc) || methodSignature.equals(signature))) {
            this.methodFound = true;
            return new ProjectMethodVisitor(this.methodResult, this.identifier.getContainingClass());
        }
        return null;
    }

    @Override
    public void visitEnd() {
        if (!this.methodFound && !this.superName.equals("java/lang/Object")) {
            try {
                ClassReader classReader = new ClassReader(this.superName);
                ProjectMethodClassVisitor visitor = new ProjectMethodClassVisitor(this.methodResult, this.identifier);
                classReader.accept(visitor, 8);
            }
            catch (IOException e) {
                LogProvider.error("Could not analyze project method " + this.superName + "#" + this.identifier.getMethodName());
                LogProvider.debug(e);
            }
        }
    }
}

