/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.classes;

import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.collection.InstructionBuilder;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.DefaultInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.ExceptionHandlerInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.LoadInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.LoadStoreInstructionPlaceholder;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.PushInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.SizeChangingInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.StoreInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.results.MethodResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Stream;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.Printer;

class ProjectMethodVisitor
extends MethodVisitor {
    private final Set<Label> exceptionHandlers = new HashSet<Label>();
    private final List<Label> visitedLabels = new ArrayList<Label>();
    final MethodResult methodResult;
    private final String className;

    ProjectMethodVisitor(MethodResult methodResult, String className) {
        super(327680);
        this.methodResult = methodResult;
        this.className = className;
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.exceptionHandlers.add(handler);
    }

    @Override
    public void visitLabel(Label label) {
        this.visitedLabels.add(label);
        if (this.exceptionHandlers.remove(label)) {
            this.methodResult.getInstructions().add(new ExceptionHandlerInstruction(label));
        }
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack, maxLocals);
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        ListIterator<Instruction> iterator = this.methodResult.getInstructions().listIterator();
        while (iterator.hasNext()) {
            Label label;
            LoadStoreInstructionPlaceholder placeholder;
            Instruction instruction = iterator.next();
            if (instruction.getType() != Instruction.InstructionType.LOAD_PLACEHOLDER && instruction.getType() != Instruction.InstructionType.STORE_PLACEHOLDER || (placeholder = (LoadStoreInstructionPlaceholder)instruction).getNumber() != index || !this.isLabelActive(label = placeholder.getLabel(), start, end)) continue;
            String type = signature != null ? signature : desc;
            iterator.set(placeholder.getType() == Instruction.InstructionType.LOAD_PLACEHOLDER ? new LoadInstruction(index, type, name, label, end) : new StoreInstruction(index, type, name, label));
        }
    }

    private boolean isLabelActive(Label label, Label start, Label end) {
        boolean startVisited = false;
        for (Label current : this.visitedLabels) {
            if (current == start) {
                startVisited = true;
            }
            if (current == label) {
                return startVisited;
            }
            if (current != end) continue;
            return false;
        }
        return false;
    }

    @Override
    public void visitInsn(int opcode) {
        this.methodResult.getInstructions().add(InstructionBuilder.buildInstruction(opcode, this.getLastLabel()));
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.methodResult.getInstructions().add(InstructionBuilder.buildIntInstruction(opcode, operand, this.getLastLabel()));
    }

    @Override
    public void visitVarInsn(int opcode, int index) {
        Label label = !this.visitedLabels.isEmpty() ? this.visitedLabels.get(this.visitedLabels.size() - 1) : null;
        this.methodResult.getInstructions().add(InstructionBuilder.buildLoadStoreInstruction(opcode, index, label));
    }

    @Override
    public void visitTypeInsn(int opcode, String className) {
        this.methodResult.getInstructions().add(InstructionBuilder.buildTypeInstruction(opcode, className, this.getLastLabel()));
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.methodResult.getInstructions().add(InstructionBuilder.buildFieldInstruction(opcode, owner, name, desc, this.getLastLabel()));
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.methodResult.getInstructions().add(InstructionBuilder.buildInvokeInstruction(opcode, owner, name, desc, this.getLastLabel()));
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        Handle handle = Stream.of(bsmArgs).filter(a -> a instanceof Handle).map(a -> (Handle)a).findAny().orElseThrow(() -> new IllegalStateException("No invoke dynamic handle found."));
        this.methodResult.getInstructions().add(InstructionBuilder.buildInvokeDynamic(this.className, name, desc, handle, this.getLastLabel()));
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.methodResult.getInstructions().add(InstructionBuilder.buildJumpInstruction(opcode, label));
    }

    @Override
    public void visitLdcInsn(Object object) {
        this.methodResult.getInstructions().add(this.createLdcInstruction(object, this.getLastLabel()));
    }

    private Label getLastLabel() {
        if (this.visitedLabels.isEmpty()) {
            return null;
        }
        return this.visitedLabels.get(this.visitedLabels.size() - 1);
    }

    private PushInstruction createLdcInstruction(Object object, Label label) {
        if (object instanceof Integer) {
            return new PushInstruction(object, "Ljava/lang/Integer;", label);
        }
        if (object instanceof Float) {
            return new PushInstruction(object, "Ljava/lang/Float;", label);
        }
        if (object instanceof Long) {
            return new PushInstruction(object, "Ljava/lang/Long;", label);
        }
        if (object instanceof Double) {
            return new PushInstruction(object, "Ljava/lang/Double;", label);
        }
        if (object instanceof String) {
            return new PushInstruction(object, "Ljava/lang/String;", label);
        }
        if (object instanceof Type) {
            return new PushInstruction(((Type)object).getDescriptor(), "Ljava/lang/Class;", label);
        }
        return new PushInstruction(object, Type.getDescriptor(object.getClass()), label);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.methodResult.getInstructions().add(new DefaultInstruction(Printer.OPCODES[132], this.getLastLabel()));
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.methodResult.getInstructions().add(new SizeChangingInstruction(Printer.OPCODES[170], 0, 1, this.getLastLabel()));
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.methodResult.getInstructions().add(new SizeChangingInstruction(Printer.OPCODES[171], 0, 1, this.getLastLabel()));
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dimensions) {
        this.methodResult.getInstructions().add(new SizeChangingInstruction(Printer.OPCODES[197], 1, dimensions, this.getLastLabel()));
    }

    @Override
    public void visitEnd() {
        ListIterator<Instruction> listIterator = this.methodResult.getInstructions().listIterator();
        while (listIterator.hasNext()) {
            Instruction instruction = listIterator.next();
            if (instruction.getType() == Instruction.InstructionType.LOAD_PLACEHOLDER) {
                listIterator.set(new LoadInstruction(((LoadStoreInstructionPlaceholder)instruction).getNumber(), "Ljava/lang/Object;", instruction.getLabel(), null));
                continue;
            }
            if (instruction.getType() != Instruction.InstructionType.STORE_PLACEHOLDER) continue;
            listIterator.set(new StoreInstruction(((LoadStoreInstructionPlaceholder)instruction).getNumber(), "Ljava/lang/Object;", instruction.getLabel()));
        }
    }
}

