/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.backend;

import com.sebastian_daschner.jaxrs_analyzer.backend.Backend;
import com.sebastian_daschner.jaxrs_analyzer.backend.JsonRepresentationAppender;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Project;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.ResourceMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Resources;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeRepresentationVisitor;
import java.util.Comparator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class StringBackend
implements Backend {
    protected final Lock lock = new ReentrantLock();
    protected StringBuilder builder;
    protected Resources resources;
    protected String projectName;
    protected String projectVersion;
    protected TypeRepresentationVisitor visitor;

    private void initRender(Project project) {
        this.builder = new StringBuilder();
        this.resources = project.getResources();
        this.projectName = project.getName();
        this.projectVersion = project.getVersion();
        this.visitor = new JsonRepresentationAppender(this.builder, this.resources.getTypeRepresentations());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] render(Project project) {
        this.lock.lock();
        try {
            this.initRender(project);
            String output = this.renderInternal();
            byte[] byArray = StringBackend.serialize(output);
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    private String renderInternal() {
        this.appendHeader();
        this.resources.getResources().stream().sorted().forEach(this::appendResource);
        return this.builder.toString();
    }

    private void appendHeader() {
        this.appendFirstLine();
        this.builder.append(this.projectVersion).append("\n\n");
    }

    private void appendResource(String resource) {
        this.resources.getMethods(resource).stream().sorted(Comparator.comparing(ResourceMethod::getMethod)).forEach(resourceMethod -> {
            this.appendMethod(this.resources.getBasePath(), resource, (ResourceMethod)resourceMethod);
            this.appendRequest((ResourceMethod)resourceMethod);
            this.appendResponse((ResourceMethod)resourceMethod);
            this.appendResourceEnd();
        });
    }

    protected abstract void appendFirstLine();

    protected abstract void appendMethod(String var1, String var2, ResourceMethod var3);

    protected abstract void appendRequest(ResourceMethod var1);

    protected abstract void appendResponse(ResourceMethod var1);

    protected void appendResourceEnd() {
    }

    private static byte[] serialize(String output) {
        return output.getBytes();
    }
}

