/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.backend.swagger;

import com.sebastian_daschner.jaxrs_analyzer.backend.Backend;
import com.sebastian_daschner.jaxrs_analyzer.backend.ComparatorUtils;
import com.sebastian_daschner.jaxrs_analyzer.backend.swagger.SchemaBuilder;
import com.sebastian_daschner.jaxrs_analyzer.backend.swagger.SwaggerOptions;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.MethodParameter;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.ParameterType;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Project;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.ResourceMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Resources;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Response;
import com.sebastian_daschner.jaxrs_analyzer.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import javax.ws.rs.core.Response;

public class SwaggerBackend
implements Backend {
    private static final String NAME = "Swagger";
    private static final String SWAGGER_VERSION = "2.0";
    private final Lock lock = new ReentrantLock();
    private final SwaggerOptions options = new SwaggerOptions();
    private Resources resources;
    private JsonObjectBuilder builder;
    private SchemaBuilder schemaBuilder;
    private String projectName;
    private String projectVersion;

    @Override
    public void configure(Map<String, String> config) {
        this.options.configure(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] render(Project project) {
        this.lock.lock();
        try {
            this.builder = Json.createObjectBuilder();
            this.resources = project.getResources();
            this.projectName = project.getName();
            this.projectVersion = project.getVersion();
            this.schemaBuilder = new SchemaBuilder(this.resources.getTypeRepresentations());
            JsonObject output = this.modifyJson(this.renderInternal());
            byte[] byArray = SwaggerBackend.serialize(output);
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    private JsonObject modifyJson(JsonObject json) {
        if (this.options.getJsonPatch() == null) {
            return json;
        }
        return this.options.getJsonPatch().apply(json);
    }

    private JsonObject renderInternal() {
        this.appendHeader();
        this.appendPaths();
        this.appendDefinitions();
        return this.builder.build();
    }

    private void appendHeader() {
        this.builder.add("swagger", SWAGGER_VERSION).add("info", Json.createObjectBuilder().add("version", this.projectVersion).add("title", this.projectName)).add("host", this.options.getDomain()).add("basePath", '/' + this.resources.getBasePath()).add("schemes", this.options.getSchemes().stream().map(Enum::name).map(String::toLowerCase).sorted().collect(Json::createArrayBuilder, JsonArrayBuilder::add, JsonArrayBuilder::add).build());
        if (this.options.isRenderTags()) {
            JsonArrayBuilder tags = Json.createArrayBuilder();
            this.resources.getResources().stream().map(this::extractTag).filter(Objects::nonNull).distinct().sorted().forEach(tags::add);
            this.builder.add("tags", tags);
        }
    }

    private String extractTag(String s) {
        int offset = this.options.getTagsPathOffset();
        String[] parts = s.split("/");
        if (parts.length > offset && !parts[offset].contains("{")) {
            return parts[offset];
        }
        return null;
    }

    private void appendPaths() {
        JsonObjectBuilder paths = Json.createObjectBuilder();
        this.resources.getResources().stream().sorted().forEach(s -> paths.add('/' + s, this.buildPathDefinition((String)s)));
        this.builder.add("paths", paths);
    }

    private JsonObjectBuilder buildPathDefinition(String s) {
        JsonObjectBuilder methods = Json.createObjectBuilder();
        this.resources.getMethods(s).stream().sorted(Comparator.comparing(ResourceMethod::getMethod)).forEach(m -> methods.add(m.getMethod().toString().toLowerCase(), this.buildForMethod((ResourceMethod)m, s)));
        return methods;
    }

    private JsonObjectBuilder buildForMethod(ResourceMethod method, String s) {
        JsonArrayBuilder consumes = Json.createArrayBuilder();
        method.getRequestMediaTypes().stream().sorted().forEach(consumes::add);
        JsonArrayBuilder produces = Json.createArrayBuilder();
        method.getResponseMediaTypes().stream().sorted().forEach(produces::add);
        JsonObjectBuilder builder = Json.createObjectBuilder();
        if (method.getDescription() != null) {
            builder.add("description", method.getDescription());
        }
        builder.add("consumes", consumes).add("produces", produces).add("parameters", this.buildParameters(method)).add("responses", this.buildResponses(method));
        if (this.options.isRenderTags()) {
            Optional.ofNullable(this.extractTag(s)).ifPresent(t -> builder.add("tags", Json.createArrayBuilder().add((String)t)));
        }
        return builder;
    }

    private JsonArrayBuilder buildParameters(ResourceMethod method) {
        Set<MethodParameter> parameters = method.getMethodParameters();
        JsonArrayBuilder parameterBuilder = Json.createArrayBuilder();
        this.buildParameters(parameters, ParameterType.PATH, parameterBuilder);
        this.buildParameters(parameters, ParameterType.HEADER, parameterBuilder);
        this.buildParameters(parameters, ParameterType.QUERY, parameterBuilder);
        this.buildParameters(parameters, ParameterType.FORM, parameterBuilder);
        if (method.getRequestBody() != null) {
            JsonObjectBuilder requestBuilder = Json.createObjectBuilder().add("name", "body").add("in", "body").add("required", true).add("schema", this.schemaBuilder.build(method.getRequestBody()));
            if (!StringUtils.isBlank(method.getRequestBodyDescription())) {
                requestBuilder.add("description", method.getRequestBodyDescription());
            }
            parameterBuilder.add(requestBuilder);
        }
        return parameterBuilder;
    }

    private void buildParameters(Set<MethodParameter> parameters, ParameterType parameterType, JsonArrayBuilder builder) {
        parameters.stream().filter(p -> p.getParameterType() == parameterType).sorted(ComparatorUtils.parameterComparator()).forEach(e -> {
            String swaggerParameterType = SwaggerBackend.getSwaggerParameterType(parameterType);
            if (swaggerParameterType != null) {
                JsonObjectBuilder paramBuilder = this.schemaBuilder.build(e.getType()).add("name", e.getName()).add("in", swaggerParameterType).add("required", e.getDefaultValue() == null);
                if (!StringUtils.isBlank(e.getDescription())) {
                    paramBuilder.add("description", e.getDescription());
                }
                builder.add(paramBuilder);
            }
        });
    }

    private JsonObjectBuilder buildResponses(ResourceMethod method) {
        JsonObjectBuilder responses = Json.createObjectBuilder();
        method.getResponses().entrySet().stream().sorted(ComparatorUtils.mapKeyComparator()).forEach(e -> {
            JsonObject schema;
            JsonObjectBuilder headers = Json.createObjectBuilder();
            ((Response)e.getValue()).getHeaders().stream().sorted().forEach(h -> headers.add((String)h, Json.createObjectBuilder().add("type", "string")));
            JsonObjectBuilder response = Json.createObjectBuilder().add("description", Optional.ofNullable(Response.Status.fromStatusCode((Integer)e.getKey())).map(Response.Status::getReasonPhrase).orElse("")).add("headers", headers);
            if (((Response)e.getValue()).getResponseBody() != null && !(schema = this.schemaBuilder.build(((Response)e.getValue()).getResponseBody()).build()).isEmpty()) {
                response.add("schema", schema);
            }
            responses.add(((Integer)e.getKey()).toString(), response);
        });
        return responses;
    }

    private void appendDefinitions() {
        this.builder.add("definitions", this.schemaBuilder.getDefinitions());
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static String getSwaggerParameterType(ParameterType parameterType) {
        switch (parameterType) {
            case QUERY: {
                return "query";
            }
            case PATH: {
                return "path";
            }
            case HEADER: {
                return "header";
            }
            case FORM: {
                return "formData";
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] serialize(JsonObject jsonObject) {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            Map<String, Boolean> config = Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true);
            JsonWriter jsonWriter = Json.createWriterFactory(config).createWriter(output);
            jsonWriter.write(jsonObject);
            jsonWriter.close();
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write Swagger output", e);
        }
    }
}

