/*
 * Decompiled with CFR 0.152.
 */
package javax.json;

import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonPatch;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public final class JsonPatchBuilder {
    private JsonArrayBuilder builder;

    public JsonPatchBuilder(JsonArray patch) {
        this.builder = Json.createArrayBuilder(patch);
    }

    public JsonPatchBuilder() {
        this.builder = Json.createArrayBuilder();
    }

    public JsonStructure apply(JsonStructure target) {
        return this.build().apply(target);
    }

    public JsonObject apply(JsonObject target) {
        return this.build().apply(target);
    }

    public JsonArray apply(JsonArray target) {
        return this.build().apply(target);
    }

    public JsonPatchBuilder add(String path, JsonValue value) {
        this.builder.add(Json.createObjectBuilder().add("op", "add").add("path", path).add("value", value));
        return this;
    }

    public JsonPatchBuilder add(String path, String value) {
        this.builder.add(Json.createObjectBuilder().add("op", "add").add("path", path).add("value", value));
        return this;
    }

    public JsonPatchBuilder add(String path, int value) {
        this.builder.add(Json.createObjectBuilder().add("op", "add").add("path", path).add("value", value));
        return this;
    }

    public JsonPatchBuilder add(String path, boolean value) {
        this.builder.add(Json.createObjectBuilder().add("op", "add").add("path", path).add("value", value));
        return this;
    }

    public JsonPatchBuilder remove(String path) {
        this.builder.add(Json.createObjectBuilder().add("op", "remove").add("path", path));
        return this;
    }

    public JsonPatchBuilder replace(String path, JsonValue value) {
        this.builder.add(Json.createObjectBuilder().add("op", "replace").add("path", path).add("value", value));
        return this;
    }

    public JsonPatchBuilder replace(String path, String value) {
        this.builder.add(Json.createObjectBuilder().add("op", "replace").add("path", path).add("value", value));
        return this;
    }

    public JsonPatchBuilder replace(String path, int value) {
        this.builder.add(Json.createObjectBuilder().add("op", "replace").add("path", path).add("value", value));
        return this;
    }

    public JsonPatchBuilder replace(String path, boolean value) {
        this.builder.add(Json.createObjectBuilder().add("op", "replace").add("path", path).add("value", value));
        return this;
    }

    public JsonPatchBuilder move(String path, String from) {
        this.builder.add(Json.createObjectBuilder().add("op", "move").add("path", path).add("from", from));
        return this;
    }

    public JsonPatchBuilder copy(String path, String from) {
        this.builder.add(Json.createObjectBuilder().add("op", "copy").add("path", path).add("from", from));
        return this;
    }

    public JsonPatchBuilder test(String path, JsonValue value) {
        this.builder.add(Json.createObjectBuilder().add("op", "test").add("path", path).add("value", value));
        return this;
    }

    public JsonPatchBuilder test(String path, String value) {
        this.builder.add(Json.createObjectBuilder().add("op", "test").add("path", path).add("value", value));
        return this;
    }

    public JsonPatchBuilder test(String path, int value) {
        this.builder.add(Json.createObjectBuilder().add("op", "test").add("path", path).add("value", value));
        return this;
    }

    public JsonPatchBuilder test(String path, boolean value) {
        this.builder.add(Json.createObjectBuilder().add("op", "test").add("path", path).add("value", value));
        return this;
    }

    public JsonArray buildAsJsonArray() {
        return this.builder.build();
    }

    public JsonPatch build() {
        return new JsonPatch(this.buildAsJsonArray());
    }
}

