/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer;

import com.sebastian_daschner.jaxrs_analyzer.analysis.ProjectAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.backend.plaintext.PlainTextBackend;
import com.sebastian_daschner.jaxrs_analyzer.backend.swagger.SwaggerBackend;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Resources;
import java.nio.file.Path;
import java.nio.file.Paths;

public class Main {
    public static void main(String ... args) {
        Path projectLocation;
        if (args.length < 1) {
            System.err.println("Usage: java -jar rest-documentation-analyzer.jar <projectPath> [<backend>]");
            System.err.println("Backends: swagger (default), plaintext");
            System.exit(1);
        }
        if (!(projectLocation = Paths.get(args[0], new String[0])).toFile().exists() || !projectLocation.toFile().isDirectory()) {
            System.err.println("Please provide a valid directory!");
            System.exit(1);
        }
        Resources resources = new ProjectAnalyzer(new Path[0]).analyze(projectLocation);
        SwaggerBackend backend = args.length >= 2 && "plaintext".equals(args[1]) ? new PlainTextBackend() : new SwaggerBackend();
        String output = backend.render(resources);
        System.out.println(output);
    }
}

