/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.collection;

import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.collection.FieldInstructionBuilder;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.collection.InvokeInstructionBuilder;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.collection.LdcPushInstructionBuilder;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.collection.LoadStoreInstructionBuilder;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.collection.NewInstructionBuilder;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.collection.WideInstructionBuilder;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.DefaultInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.DupInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.ExceptionHandlerInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.PushInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.ReturnInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.SizeChangingInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.ThrowInstruction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.IntStream;
import javassist.CtBehavior;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.ExceptionTable;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.Mnemonic;
import javassist.bytecode.Opcode;

public class ByteCodeCollector
implements Opcode {
    private final Lock lock = new ReentrantLock();
    private CodeIterator codeIterator;
    private Set<Integer> exceptionHandlerPositions;
    private InvokeInstructionBuilder invokeInstructionBuilder;
    private FieldInstructionBuilder fieldInstructionBuilder;
    private LoadStoreInstructionBuilder loadStoreInstructionBuilder;
    private LdcPushInstructionBuilder ldcPushInstructionBuilder;
    private WideInstructionBuilder wideInstructionBuilder;
    private NewInstructionBuilder newInstructionBuilder;

    public List<Instruction> buildInstructions(CtBehavior method) {
        this.lock.lock();
        try {
            this.initializeBuilders(method);
            ArrayList<Instruction> instructions = new ArrayList<Instruction>();
            this.codeIterator.move(0);
            while (this.codeIterator.hasNext()) {
                int position = this.codeIterator.next();
                if (this.exceptionHandlerPositions.contains(position)) {
                    instructions.add(new ExceptionHandlerInstruction());
                }
                instructions.add(this.interpretInstruction(position));
            }
            ArrayList<Instruction> arrayList = instructions;
            return arrayList;
        }
        catch (BadBytecode e) {
            throw new IllegalStateException("Could not analyze byte code.", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void initializeBuilders(CtBehavior method) {
        MethodInfo methodInfo = method.getMethodInfo();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        ConstPool pool = methodInfo.getConstPool();
        this.codeIterator = codeAttribute.iterator();
        this.invokeInstructionBuilder = new InvokeInstructionBuilder(this.codeIterator, pool);
        this.fieldInstructionBuilder = new FieldInstructionBuilder(this.codeIterator, pool);
        this.loadStoreInstructionBuilder = new LoadStoreInstructionBuilder(codeAttribute);
        this.ldcPushInstructionBuilder = new LdcPushInstructionBuilder(pool);
        this.wideInstructionBuilder = new WideInstructionBuilder(this.codeIterator, this.loadStoreInstructionBuilder);
        this.newInstructionBuilder = new NewInstructionBuilder(this.codeIterator, pool);
        this.exceptionHandlerPositions = this.buildExceptionHandlerPositions(codeAttribute.getExceptionTable());
    }

    private Set<Integer> buildExceptionHandlerPositions(ExceptionTable exceptionTable) {
        return IntStream.range(0, exceptionTable.size()).map(exceptionTable::handlerPc).collect(HashSet::new, Set::add, Set::addAll);
    }

    private Instruction interpretInstruction(int position) throws BadBytecode {
        int currentByte = this.codeIterator.byteAt(position);
        String opCodeName = Mnemonic.OPCODE[currentByte];
        switch (currentByte) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return this.loadStoreInstructionBuilder.buildLoad(this.codeIterator.byteAt(position + 1));
            }
            case 26: 
            case 30: 
            case 34: 
            case 38: 
            case 42: {
                return this.loadStoreInstructionBuilder.buildLoad(0);
            }
            case 27: 
            case 31: 
            case 35: 
            case 39: 
            case 43: {
                return this.loadStoreInstructionBuilder.buildLoad(1);
            }
            case 28: 
            case 32: 
            case 36: 
            case 40: 
            case 44: {
                return this.loadStoreInstructionBuilder.buildLoad(2);
            }
            case 29: 
            case 33: 
            case 37: 
            case 41: 
            case 45: {
                return this.loadStoreInstructionBuilder.buildLoad(3);
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return this.loadStoreInstructionBuilder.buildStore(this.codeIterator.byteAt(position + 1));
            }
            case 59: 
            case 63: 
            case 67: 
            case 71: 
            case 75: {
                return this.loadStoreInstructionBuilder.buildStore(0);
            }
            case 60: 
            case 64: 
            case 68: 
            case 72: 
            case 76: {
                return this.loadStoreInstructionBuilder.buildStore(1);
            }
            case 61: 
            case 65: 
            case 69: 
            case 73: 
            case 77: {
                return this.loadStoreInstructionBuilder.buildStore(2);
            }
            case 62: 
            case 66: 
            case 70: 
            case 74: 
            case 78: {
                return this.loadStoreInstructionBuilder.buildStore(3);
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                return new ReturnInstruction();
            }
            case 3: {
                return new PushInstruction(0);
            }
            case 4: {
                return new PushInstruction(1);
            }
            case 5: {
                return new PushInstruction(2);
            }
            case 6: {
                return new PushInstruction(3);
            }
            case 7: {
                return new PushInstruction(4);
            }
            case 8: {
                return new PushInstruction(5);
            }
            case 2: {
                return new PushInstruction(-1);
            }
            case 14: {
                return new PushInstruction(0.0);
            }
            case 15: {
                return new PushInstruction(1.0);
            }
            case 11: {
                return new PushInstruction(Float.valueOf(0.0f));
            }
            case 12: {
                return new PushInstruction(Float.valueOf(1.0f));
            }
            case 13: {
                return new PushInstruction(Float.valueOf(2.0f));
            }
            case 9: {
                return new PushInstruction(0L);
            }
            case 10: {
                return new PushInstruction(1L);
            }
            case 18: {
                return this.ldcPushInstructionBuilder.build(this.codeIterator.byteAt(position + 1));
            }
            case 19: 
            case 20: {
                return this.ldcPushInstructionBuilder.build(this.codeIterator.u16bitAt(position + 1));
            }
            case 16: {
                return new PushInstruction(this.codeIterator.byteAt(position + 1));
            }
            case 17: {
                return new PushInstruction(this.codeIterator.s16bitAt(position + 1));
            }
            case 178: {
                return this.fieldInstructionBuilder.buildGetStatic(position);
            }
            case 180: {
                return this.fieldInstructionBuilder.buildGetField(position);
            }
            case 187: {
                return this.newInstructionBuilder.build(position);
            }
            case 1: 
            case 168: 
            case 201: {
                return new SizeChangingInstruction(opCodeName, 1, 0);
            }
            case 89: 
            case 92: {
                return new DupInstruction();
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 181: {
                return new SizeChangingInstruction(opCodeName, 0, 2);
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                return new SizeChangingInstruction(opCodeName, 1, 2);
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                return new SizeChangingInstruction(opCodeName, 0, 3);
            }
            case 95: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 188: 
            case 189: 
            case 190: 
            case 193: {
                return new SizeChangingInstruction(opCodeName, 1, 1);
            }
            case 87: 
            case 88: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 179: 
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                return new SizeChangingInstruction(opCodeName, 0, 1);
            }
            case 90: 
            case 93: {
                return new SizeChangingInstruction(opCodeName, 3, 2);
            }
            case 91: 
            case 94: {
                return new SizeChangingInstruction(opCodeName, 4, 3);
            }
            case 197: {
                return new SizeChangingInstruction(opCodeName, 1, this.codeIterator.byteAt(position + 3));
            }
            case 182: 
            case 183: 
            case 185: {
                return this.invokeInstructionBuilder.build(position);
            }
            case 184: {
                return this.invokeInstructionBuilder.buildStatic(position);
            }
            case 186: {
                return this.invokeInstructionBuilder.buildDynamic(position);
            }
            case 191: {
                return new ThrowInstruction();
            }
            case 0: 
            case 132: 
            case 167: 
            case 169: 
            case 177: 
            case 192: 
            case 200: {
                return new DefaultInstruction(opCodeName);
            }
            case 196: {
                return this.wideInstructionBuilder.build(position);
            }
        }
        throw new UnsupportedOperationException(opCodeName + " not handled!");
    }
}

