/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.collection;

import com.sebastian_daschner.jaxrs_analyzer.analysis.utils.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.InvokeDynamicInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.InvokeInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.BootstrapMethodsAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.SignatureAttribute;

class InvokeInstructionBuilder {
    private final CodeIterator codeIterator;
    private final ConstPool pool;

    InvokeInstructionBuilder(CodeIterator codeIterator, ConstPool pool) {
        this.codeIterator = codeIterator;
        this.pool = pool;
    }

    InvokeInstruction build(int position) throws BadBytecode {
        int methodRefIndex = this.codeIterator.u16bitAt(position + 1);
        return this.buildInvokeInstruction(methodRefIndex, false);
    }

    InvokeInstruction buildStatic(int position) throws BadBytecode {
        int methodRefIndex = this.codeIterator.u16bitAt(position + 1);
        return this.buildInvokeInstruction(methodRefIndex, true);
    }

    InvokeInstruction buildDynamic(int position) throws BadBytecode {
        CtClass ctClass;
        int index = this.codeIterator.u16bitAt(position + 1);
        int bootstrapIndex = this.pool.getInvokeDynamicBootstrap(index);
        int lambdaIndex = this.pool.getInvokeDynamicNameAndType(index);
        String lambdaSignature = this.pool.getUtf8Info(this.pool.getNameAndTypeDescriptor(lambdaIndex));
        String lambdaMethodName = this.pool.getUtf8Info(this.pool.getNameAndTypeName(lambdaIndex));
        SignatureAttribute.MethodSignature methodSignature = SignatureAttribute.toMethodSignature(lambdaSignature);
        String lambdaReturnType = JavaUtils.getMethodReturnType(methodSignature);
        MethodIdentifier dynamicIdentifier = MethodIdentifier.ofStatic(this.pool.getClassName(), lambdaMethodName, lambdaReturnType, JavaUtils.getMethodParameters(methodSignature));
        try {
            ctClass = ClassPool.getDefault().get(this.pool.getClassName());
        }
        catch (NotFoundException e) {
            throw new IllegalStateException("Could not analyze bytecode");
        }
        BootstrapMethodsAttribute bootstrapMethods = (BootstrapMethodsAttribute)ctClass.getClassFile().getAttribute("BootstrapMethods");
        int actualMethodIndex = bootstrapMethods.getMethods()[bootstrapIndex].arguments[1];
        int actualMethodRefIndex = this.pool.getMethodHandleIndex(actualMethodIndex);
        boolean actualMethodStatic = this.pool.getMethodHandleKind(actualMethodIndex) == 6;
        MethodIdentifier actualIdentifier = this.buildInvokeInstruction(actualMethodRefIndex, actualMethodStatic).getIdentifier();
        return new InvokeDynamicInstruction(actualIdentifier, dynamicIdentifier);
    }

    private InvokeInstruction buildInvokeInstruction(int methodRefIndex, boolean staticMethod) throws BadBytecode {
        int methodTag = this.pool.getTag(methodRefIndex);
        String className = this.getClassName(methodRefIndex, methodTag);
        String methodName = this.getMethodName(methodRefIndex, methodTag);
        String poolMethodType = this.getMethodType(methodRefIndex, methodTag);
        MethodIdentifier identifier = InvokeInstructionBuilder.buildMethodIdentifier(className, methodName, poolMethodType, staticMethod);
        return new InvokeInstruction(identifier);
    }

    private String getMethodType(int methodRefIndex, int methodTag) {
        if (methodTag == 10) {
            return this.pool.getMethodrefType(methodRefIndex);
        }
        return this.pool.getInterfaceMethodrefType(methodRefIndex);
    }

    private String getClassName(int methodRefIndex, int methodTag) {
        if (methodTag == 10) {
            return this.pool.getMethodrefClassName(methodRefIndex);
        }
        return this.pool.getInterfaceMethodrefClassName(methodRefIndex);
    }

    private String getMethodName(int methodRefIndex, int methodTag) {
        if (methodTag == 10) {
            return this.pool.getMethodrefName(methodRefIndex);
        }
        return this.pool.getInterfaceMethodrefName(methodRefIndex);
    }

    private static MethodIdentifier buildMethodIdentifier(String className, String methodName, String poolMethodType, boolean staticMethod) throws BadBytecode {
        SignatureAttribute.MethodSignature methodSignature = SignatureAttribute.toMethodSignature(poolMethodType);
        String returnType = JavaUtils.getMethodReturnType(methodSignature);
        String[] parameterTypes = JavaUtils.getMethodParameters(methodSignature);
        return MethodIdentifier.of(className, methodName, returnType, staticMethod, parameterTypes);
    }
}

