/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.project.methods;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.collection.ByteCodeCollector;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.reduction.RelevantInstructionReducer;
import com.sebastian_daschner.jaxrs_analyzer.analysis.utils.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.InvokeInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.ProjectMethod;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;

abstract class MethodContentAnalyzer {
    private static final int PROJECT_PACKAGE_HIERARCHIES = 2;
    private final ByteCodeCollector byteCodeCollector = new ByteCodeCollector();
    private final RelevantInstructionReducer instructionReducer = new RelevantInstructionReducer();
    protected String projectPackagePrefix;

    MethodContentAnalyzer() {
    }

    protected List<Instruction> interpretRelevantInstructions(CtBehavior method) {
        List<Instruction> allInstructions = this.byteCodeCollector.buildInstructions(method);
        return this.instructionReducer.reduceInstructions(allInstructions);
    }

    protected void buildPackagePrefix(CtMethod method) {
        String packageName = method.getDeclaringClass().getPackageName();
        String[] splitPackage = packageName.split("\\.");
        this.projectPackagePrefix = splitPackage.length >= 2 ? String.join((CharSequence)".", splitPackage[0], splitPackage[1]) : packageName;
    }

    protected Set<ProjectMethod> findProjectMethods(List<Instruction> instructions) {
        HashSet<ProjectMethod> projectMethods = new HashSet<ProjectMethod>();
        this.addProjectMethods(instructions, projectMethods);
        return projectMethods;
    }

    private void addProjectMethods(List<Instruction> instructions, Set<ProjectMethod> projectMethods) {
        Set<MethodIdentifier> projectMethodIdentifiers = this.findUnhandledProjectMethodIdentifiers(instructions, projectMethods);
        for (MethodIdentifier identifier : projectMethodIdentifiers) {
            List<Instruction> nestedMethodInstructions;
            try {
                nestedMethodInstructions = this.getRelevantInstructions(identifier);
            }
            catch (NotFoundException e) {
                LogProvider.getLogger().accept("Could not interpret project method: " + identifier);
                continue;
            }
            projectMethods.add(new ProjectMethod(identifier, nestedMethodInstructions));
            this.addProjectMethods(nestedMethodInstructions, projectMethods);
        }
    }

    private Set<MethodIdentifier> findUnhandledProjectMethodIdentifiers(List<Instruction> instructions, Set<ProjectMethod> projectMethods) {
        return instructions.stream().filter(i -> i.getType() == Instruction.Type.INVOKE || i.getType() == Instruction.Type.METHOD_HANDLE).map(i -> (InvokeInstruction)i).filter(this::isProjectMethod).map(InvokeInstruction::getIdentifier).filter(i -> projectMethods.stream().noneMatch(m -> m.matches((MethodIdentifier)i))).collect(Collectors.toSet());
    }

    private List<Instruction> getRelevantInstructions(MethodIdentifier identifier) throws NotFoundException {
        CtClass[] parameterClasses = JavaUtils.getParameterClasses(identifier);
        CtClass ctClass = ClassPool.getDefault().get(identifier.getClassName());
        CtBehavior method = JavaUtils.isInitializerName(identifier.getMethodName()) ? ctClass.getDeclaredConstructor(parameterClasses) : ctClass.getDeclaredMethod(identifier.getMethodName(), parameterClasses);
        return this.interpretRelevantInstructions(method);
    }

    private boolean isProjectMethod(InvokeInstruction instruction) {
        MethodIdentifier identifier = instruction.getIdentifier();
        return identifier.getClassName().startsWith(this.projectPackagePrefix);
    }
}

