/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.project.methods;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation.MethodPool;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation.MethodSimulator;
import com.sebastian_daschner.jaxrs_analyzer.analysis.project.methods.MethodContentAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.Element;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.HttpResponse;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.ProjectMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.results.MethodResult;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javassist.CtMethod;

class ResponseMethodAnalyzer
extends MethodContentAnalyzer {
    private final Lock lock = new ReentrantLock();
    private final MethodSimulator methodSimulator = new MethodSimulator();

    ResponseMethodAnalyzer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void analyze(CtMethod method, MethodResult result) {
        this.lock.lock();
        try {
            this.buildPackagePrefix(method);
            List<Instruction> visitedInstructions = this.interpretRelevantInstructions(method);
            Set<ProjectMethod> projectMethods = this.findProjectMethods(visitedInstructions);
            projectMethods.stream().forEach(MethodPool.getInstance()::addProjectMethod);
            Element returnedElement = this.methodSimulator.simulate(visitedInstructions);
            returnedElement.getPossibleValues().stream().filter(this::filterHttpResponse).map(r -> (HttpResponse)r).forEach(result.getResponses()::add);
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean filterHttpResponse(Object object) {
        if (object instanceof HttpResponse) {
            return true;
        }
        LogProvider.getLogger().accept("Returned element of a Response method is no HttpResponse type.");
        return false;
    }
}

