/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.project.methods;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation.MethodPool;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation.MethodSimulator;
import com.sebastian_daschner.jaxrs_analyzer.analysis.project.classes.ClassAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.analysis.project.methods.MethodContentAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.ProjectMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.results.ClassResult;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;

class SubResourceLocatorMethodAnalyzer
extends MethodContentAnalyzer {
    private final Lock lock = new ReentrantLock();
    private final ClassAnalyzer classAnalyzer = new ClassAnalyzer();
    private final MethodSimulator simulator = new MethodSimulator();

    SubResourceLocatorMethodAnalyzer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void analyze(CtMethod method, ClassResult classResult) {
        this.lock.lock();
        try {
            this.buildPackagePrefix(method);
            String returnType = this.determineReturnType(method);
            CtClass subResource = ClassPool.getDefault().get(returnType);
            this.classAnalyzer.analyzeSubResource(subResource, classResult);
        }
        catch (NotFoundException e) {
            LogProvider.getLogger().accept("Could not load analyze sub-resource class ");
        }
        finally {
            this.lock.unlock();
        }
    }

    private String determineReturnType(CtMethod method) throws NotFoundException {
        List<Instruction> visitedInstructions = this.interpretRelevantInstructions(method);
        Set<ProjectMethod> projectMethods = this.findProjectMethods(visitedInstructions);
        projectMethods.stream().forEach(MethodPool.getInstance()::addProjectMethod);
        return this.simulator.simulate(visitedInstructions).getType();
    }
}

