/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.results;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.results.JsonMapper;
import com.sebastian_daschner.jaxrs_analyzer.analysis.results.PathNormalizer;
import com.sebastian_daschner.jaxrs_analyzer.analysis.results.TypeAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.HttpResponse;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.ResourceMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Resources;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Response;
import com.sebastian_daschner.jaxrs_analyzer.model.results.ClassResult;
import com.sebastian_daschner.jaxrs_analyzer.model.results.MethodResult;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.ws.rs.core.Response;

public class ResultInterpreter {
    private final Lock lock = new ReentrantLock();
    private final TypeAnalyzer typeAnalyzer = new TypeAnalyzer();
    private Resources resources;

    public Resources interpret(Set<ClassResult> classResults) {
        try {
            this.lock.lock();
            this.resources = new Resources();
            this.resources.setBasePath(PathNormalizer.getApplicationPath(classResults));
            classResults.stream().filter(c -> c.getResourcePath() != null).forEach(this::interpretClassResult);
            Resources resources = this.resources;
            return resources;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void interpretClassResult(ClassResult classResult) {
        classResult.getMethods().stream().forEach(m -> this.interpretMethodResult((MethodResult)m, classResult));
    }

    private void interpretMethodResult(MethodResult methodResult, ClassResult classResult) {
        if (methodResult.getSubResource() != null) {
            this.interpretClassResult(methodResult.getSubResource());
            return;
        }
        String path = PathNormalizer.getPath(methodResult);
        ResourceMethod resourceMethod = this.interpretResourceMethod(methodResult, classResult);
        this.resources.addMethod(path, resourceMethod);
    }

    private ResourceMethod interpretResourceMethod(MethodResult methodResult, ClassResult classResult) {
        ResourceMethod resourceMethod = new ResourceMethod(methodResult.getHttpMethod(), methodResult.getMethodParameters());
        if (methodResult.getRequestBodyType() != null) {
            resourceMethod.setRequestBody(this.typeAnalyzer.analyze(methodResult.getRequestBodyType()));
        }
        this.addDefaultResponses(methodResult);
        methodResult.getResponses().stream().forEach(r -> this.interpretResponse((HttpResponse)r, resourceMethod));
        this.addMediaTypes(methodResult, classResult, resourceMethod);
        return resourceMethod;
    }

    private void addDefaultResponses(MethodResult methodResult) {
        if (methodResult.getResponses().isEmpty()) {
            HttpResponse httpResponse = new HttpResponse();
            httpResponse.getStatuses().add(Response.Status.NO_CONTENT.getStatusCode());
            methodResult.getResponses().add(httpResponse);
            return;
        }
        methodResult.getResponses().stream().filter(r -> r.getStatuses().isEmpty()).forEach(r -> r.getStatuses().add(Response.Status.OK.getStatusCode()));
    }

    private void interpretResponse(HttpResponse httpResponse, ResourceMethod method) {
        method.getResponseMediaTypes().addAll(httpResponse.getContentTypes());
        httpResponse.getStatuses().stream().forEach(s -> {
            Response response = httpResponse.getEntityTypes().isEmpty() ? new Response() : new Response(this.typeAnalyzer.analyze(httpResponse.getEntityTypes().iterator().next()));
            response.getHeaders().addAll(httpResponse.getHeaders());
            httpResponse.getInlineEntities().stream().map(JsonMapper::map).forEach(j -> response.getResponseBody().getRepresentations().put("application/json", j));
            if (httpResponse.getEntityTypes().size() > 1) {
                LogProvider.getLogger().accept("Several entity types for status " + s + " exist.");
            }
            if (httpResponse.getInlineEntities().size() > 1) {
                LogProvider.getLogger().accept("Several inline entities for status " + s + " exist.");
            }
            method.getResponses().put((Integer)s, response);
        });
    }

    private void addMediaTypes(MethodResult methodResult, ClassResult classResult, ResourceMethod resourceMethod) {
        resourceMethod.getAcceptMediaTypes().addAll(methodResult.getAcceptMediaTypes());
        if (resourceMethod.getAcceptMediaTypes().isEmpty()) {
            resourceMethod.getAcceptMediaTypes().addAll(classResult.getAcceptMediaTypes());
        }
        if (resourceMethod.getResponseMediaTypes().isEmpty()) {
            resourceMethod.getResponseMediaTypes().addAll(methodResult.getResponseMediaTypes());
        }
        if (resourceMethod.getResponseMediaTypes().isEmpty()) {
            resourceMethod.getResponseMediaTypes().addAll(classResult.getResponseMediaTypes());
        }
    }
}

