/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.backend.swagger;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.backend.swagger.SwaggerType;
import com.sebastian_daschner.jaxrs_analyzer.backend.swagger.SwaggerUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeRepresentation;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

class SchemaBuilder {
    private final Map<String, JsonObject> jsonDefinitions = new HashMap<String, JsonObject>();
    private final AtomicInteger nextDefinition = new AtomicInteger(0);

    SchemaBuilder() {
    }

    JsonObject build(TypeRepresentation representation) {
        SwaggerType type = SwaggerUtils.toSwaggerType(representation.getType());
        switch (type) {
            case BOOLEAN: 
            case INTEGER: 
            case NUMBER: 
            case NULL: 
            case STRING: {
                return this.buildForPrimitive(type);
            }
        }
        if (representation.getRepresentations().isEmpty()) {
            return Json.createObjectBuilder().build();
        }
        JsonValue json = (JsonValue)representation.getRepresentations().values().iterator().next();
        return this.build(json);
    }

    public JsonObject getDefinitions() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.jsonDefinitions.entrySet().forEach(e -> builder.add((String)e.getKey(), (JsonValue)e.getValue()));
        return builder.build();
    }

    private JsonObject build(JsonValue value) {
        SwaggerType type = SwaggerUtils.toSwaggerType(value.getValueType());
        switch (type) {
            case ARRAY: {
                return this.buildForArray((JsonArray)value);
            }
            case BOOLEAN: 
            case INTEGER: 
            case NUMBER: 
            case NULL: 
            case STRING: {
                return this.buildForPrimitive(type);
            }
            case OBJECT: {
                return this.buildForObject((JsonObject)value);
            }
        }
        LogProvider.getLogger().accept("Unknown Swagger type occurred: " + (Object)((Object)type));
        return Json.createObjectBuilder().build();
    }

    private JsonObject buildForArray(JsonArray jsonArray) {
        JsonObjectBuilder builder = Json.createObjectBuilder().add("type", "array");
        if (!jsonArray.isEmpty()) {
            if (jsonArray.size() > 1 && !jsonArray.stream().collect(() -> new EqualTester(), EqualTester::add, EqualTester::add).allEqual()) {
                builder.add("items", jsonArray.stream().map(this::build).collect(Json::createArrayBuilder, JsonArrayBuilder::add, JsonArrayBuilder::add));
            } else {
                builder.add("items", this.build((JsonValue)jsonArray.get(0)));
            }
        }
        return builder.build();
    }

    private JsonObject buildForPrimitive(SwaggerType type) {
        return Json.createObjectBuilder().add("type", type.toString()).build();
    }

    private JsonObject buildForObject(JsonObject value) {
        String definition = this.nextDefinition();
        JsonObjectBuilder properties = Json.createObjectBuilder();
        value.entrySet().forEach(e -> properties.add((String)e.getKey(), this.build((JsonValue)e.getValue())));
        this.jsonDefinitions.put(definition, Json.createObjectBuilder().add("properties", properties).build());
        return Json.createObjectBuilder().add("$ref", definition).build();
    }

    private String nextDefinition() {
        return "definition#" + this.nextDefinition.incrementAndGet();
    }

    private class EqualTester {
        private JsonValue first;
        private boolean equal = true;

        private EqualTester() {
        }

        public void add(JsonValue value) {
            if (this.first == null) {
                this.first = value;
            } else {
                this.equal = this.equal && this.first.equals(value);
            }
        }

        public void add(EqualTester other) {
            if (this.first != null && other.first != null) {
                this.equal = this.equal && other.equal && this.first.equals(other.first);
            }
        }

        public boolean allEqual() {
            return this.equal;
        }
    }
}

