/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.backend.swagger;

import com.sebastian_daschner.jaxrs_analyzer.backend.Backend;
import com.sebastian_daschner.jaxrs_analyzer.backend.swagger.SchemaBuilder;
import com.sebastian_daschner.jaxrs_analyzer.backend.swagger.SwaggerUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.MethodParameters;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.ResourceMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Resources;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Response;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.ws.rs.core.Response;

public class SwaggerBackend
implements Backend {
    private static final String SWAGGER_VERSION = "2.0";
    private static final String HOST = "example.com";
    private final Lock lock = new ReentrantLock();
    private Resources resources;
    private JsonObjectBuilder builder;
    private SchemaBuilder schemaBuilder;

    @Override
    public String render(Resources resources) {
        this.lock.lock();
        try {
            this.builder = Json.createObjectBuilder();
            this.schemaBuilder = new SchemaBuilder();
            this.resources = resources;
            String string = this.renderInternal();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    private String renderInternal() {
        this.appendHeader();
        this.appendPaths();
        this.appendDefinitions();
        return this.builder.build().toString();
    }

    private void appendHeader() {
        String projectVersion = "0.1-SNAPSHOT";
        String projectName = "project";
        this.builder.add("swagger", SWAGGER_VERSION).add("info", Json.createObjectBuilder().add("version", "0.1-SNAPSHOT").add("title", "project")).add("host", HOST).add("basePath", '/' + this.resources.getBasePath()).add("schemas", Json.createArrayBuilder().add("http"));
    }

    private void appendPaths() {
        JsonObjectBuilder paths = Json.createObjectBuilder();
        this.resources.getResources().stream().sorted().forEach(s -> paths.add('/' + s, this.buildPathDefinition((String)s)));
        this.builder.add("paths", paths);
    }

    private JsonObjectBuilder buildPathDefinition(String s) {
        JsonObjectBuilder methods = Json.createObjectBuilder();
        this.resources.getMethods(s).stream().forEach(m -> methods.add(m.getMethod().toString().toLowerCase(), this.buildForMethod((ResourceMethod)m)));
        return methods;
    }

    private JsonObjectBuilder buildForMethod(ResourceMethod method) {
        JsonArrayBuilder consumes = Json.createArrayBuilder();
        method.getAcceptMediaTypes().stream().forEach(consumes::add);
        JsonArrayBuilder produces = Json.createArrayBuilder();
        method.getResponseMediaTypes().stream().forEach(produces::add);
        return Json.createObjectBuilder().add("consumes", consumes).add("produces", produces).add("parameters", this.buildParameters(method)).add("responses", this.buildResponses(method));
    }

    private JsonArrayBuilder buildParameters(ResourceMethod method) {
        MethodParameters parameters = method.getMethodParameters();
        JsonArrayBuilder parameterBuilder = Json.createArrayBuilder();
        parameters.getPathParams().entrySet().stream().forEach(e -> parameterBuilder.add(this.buildParameter((Map.Entry<String, String>)e, "path")));
        parameters.getHeaderParams().entrySet().stream().forEach(e -> parameterBuilder.add(this.buildParameter((Map.Entry<String, String>)e, "header")));
        parameters.getQueryParams().entrySet().stream().forEach(e -> parameterBuilder.add(this.buildParameter((Map.Entry<String, String>)e, "query")));
        parameters.getFormParams().entrySet().stream().forEach(e -> parameterBuilder.add(this.buildParameter((Map.Entry<String, String>)e, "formData")));
        if (method.getRequestBody() != null) {
            parameterBuilder.add(Json.createObjectBuilder().add("name", "body").add("in", "body").add("required", true).add("schema", this.schemaBuilder.build(method.getRequestBody())));
        }
        return parameterBuilder;
    }

    private JsonObjectBuilder buildParameter(Map.Entry<String, String> entry, String context) {
        return Json.createObjectBuilder().add("name", entry.getKey()).add("in", context).add("required", true).add("type", SwaggerUtils.toSwaggerType(entry.getValue()).toString());
    }

    private JsonObjectBuilder buildResponses(ResourceMethod method) {
        JsonObjectBuilder responses = Json.createObjectBuilder();
        method.getResponses().entrySet().stream().forEach(e -> {
            JsonObjectBuilder headers = Json.createObjectBuilder();
            ((Response)e.getValue()).getHeaders().forEach(h -> headers.add((String)h, Json.createObjectBuilder().add("type", "string")));
            JsonObjectBuilder response = Json.createObjectBuilder().add("description", Optional.ofNullable(Response.Status.fromStatusCode((Integer)e.getKey())).map(Response.Status::getReasonPhrase).orElse("")).add("headers", headers);
            if (((Response)e.getValue()).getResponseBody() != null) {
                response.add("schema", this.schemaBuilder.build(((Response)e.getValue()).getResponseBody()));
            }
            responses.add(((Integer)e.getKey()).toString(), response);
        });
        return responses;
    }

    private void appendDefinitions() {
        this.builder.add("definitions", this.schemaBuilder.getDefinitions());
    }
}

