/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.methods;

import com.sebastian_daschner.jaxrs_analyzer.analysis.utils.StringUtils;
import java.util.Arrays;

public class MethodIdentifier {
    private final String className;
    private final String methodName;
    private final String returnType;
    private final boolean staticMethod;
    private final String[] parameterTypes;

    private MethodIdentifier(String className, String methodName, String returnType, boolean staticMethod, String[] parameterTypes) {
        StringUtils.requireNonBlank(className);
        StringUtils.requireNonBlank(methodName);
        for (String parameterType : parameterTypes) {
            StringUtils.requireNonBlank(parameterType);
        }
        this.className = className;
        this.methodName = methodName;
        this.returnType = returnType;
        this.staticMethod = staticMethod;
        this.parameterTypes = parameterTypes;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public boolean isStaticMethod() {
        return this.staticMethod;
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodIdentifier that = (MethodIdentifier)o;
        if (!this.className.equals(that.className)) {
            return false;
        }
        if (!this.methodName.equals(that.methodName)) {
            return false;
        }
        if (this.returnType != null ? !this.returnType.equals(that.returnType) : that.returnType != null) {
            return false;
        }
        if (this.staticMethod ^ that.staticMethod) {
            return false;
        }
        return Arrays.equals(this.parameterTypes, that.parameterTypes);
    }

    public int hashCode() {
        int result = this.className.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + (this.returnType != null ? this.returnType.hashCode() : 0);
        result = 31 * result + (this.staticMethod ? 1 : 0);
        result = 31 * result + Arrays.hashCode(this.parameterTypes);
        return result;
    }

    public String toString() {
        return "{className='" + this.className + '\'' + ", methodName='" + this.methodName + '\'' + ", returnType='" + this.returnType + '\'' + ", staticMethod='" + this.staticMethod + '\'' + ", parameterTypes=" + Arrays.toString(this.parameterTypes) + '}';
    }

    public static MethodIdentifier of(String className, String methodName, String returnType, boolean staticMethod, String ... parameterTypes) {
        return new MethodIdentifier(className, methodName, returnType, staticMethod, parameterTypes);
    }

    public static MethodIdentifier ofNonStatic(String className, String methodName, String returnType, String ... parameterTypes) {
        return new MethodIdentifier(className, methodName, returnType, false, parameterTypes);
    }

    public static MethodIdentifier ofStatic(String className, String methodName, String returnType, String ... parameterTypes) {
        return new MethodIdentifier(className, methodName, returnType, true, parameterTypes);
    }
}

