/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer;

import com.sebastian_daschner.jaxrs_analyzer.analysis.ProjectAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.backend.Backend;
import com.sebastian_daschner.jaxrs_analyzer.backend.asciidoc.AsciiDocBackend;
import com.sebastian_daschner.jaxrs_analyzer.backend.plaintext.PlainTextBackend;
import com.sebastian_daschner.jaxrs_analyzer.backend.swagger.SwaggerBackend;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Project;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Resources;
import java.nio.file.Path;
import java.nio.file.Paths;

public class Main {
    private static final String DEFAULT_NAME = "project";
    private static final String DEFAULT_VERSION = "0.1-SNAPSHOT";
    private static final String DEFAULT_DOMAIN = "example.com";

    public static void main(String ... args) {
        Path projectLocation;
        if (args.length < 1) {
            System.err.println("Usage: java -jar rest-documentation-analyzer.jar <projectPath> [<backend>] [<project name>] [<project version>] [<project domain>]");
            System.err.println("Backends: swagger (default), plaintext");
            System.exit(1);
        }
        if (!(projectLocation = Paths.get(args[0], new String[0])).toFile().exists() || !projectLocation.toFile().isDirectory()) {
            System.err.println("Please provide a valid directory!");
            System.exit(1);
        }
        String name = args.length >= 3 ? args[2] : DEFAULT_NAME;
        String version = args.length >= 4 ? args[3] : DEFAULT_VERSION;
        String domain = args.length >= 5 ? args[4] : DEFAULT_DOMAIN;
        Resources resources = new ProjectAnalyzer(new Path[0]).analyze(projectLocation);
        Project project = new Project(name, version, domain, resources);
        String output = Main.chooseBackend(args.length >= 2 ? args[1] : null).render(project);
        System.out.println(output);
    }

    private static Backend chooseBackend(String backendName) {
        switch (backendName) {
            case "plaintext": {
                return new PlainTextBackend();
            }
            case "asciidoc": {
                return new AsciiDocBackend();
            }
        }
        return new SwaggerBackend();
    }
}

