/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.project.classes.ClassAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.analysis.results.ResultInterpreter;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Resources;
import com.sebastian_daschner.jaxrs_analyzer.model.results.ClassResult;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;

public class ProjectAnalyzer {
    private final Lock lock = new ReentrantLock();
    private final ClassAnalyzer classAnalyzer = new ClassAnalyzer();
    private final ResultInterpreter resultInterpreter = new ResultInterpreter();

    public ProjectAnalyzer(Path ... dependencyLocations) {
        Stream.of(dependencyLocations).forEach(ProjectAnalyzer::addToClassPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resources analyze(Path projectLocation) {
        this.lock.lock();
        try {
            ProjectAnalyzer.addToClassPool(projectLocation);
            Set<CtClass> classes = ProjectAnalyzer.getClasses(projectLocation.toString(), new String[0]);
            Set<ClassResult> classResults = classes.stream().map(this.classAnalyzer::analyze).filter(Objects::nonNull).collect(Collectors.toSet());
            Resources resources = this.resultInterpreter.interpret(classResults);
            return resources;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static void addToClassPool(Path location) {
        if (!location.toFile().exists()) {
            throw new IllegalArgumentException("The location '" + location + "' does not exist!");
        }
        try {
            ClassPool.getDefault().insertClassPath(location.toString());
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("The location '" + location + "' could not be loaded!", e);
        }
    }

    private static Set<CtClass> getClasses(String projectLocation, String ... packages) {
        File[] directories;
        File[] classFiles;
        HashSet<CtClass> classes = new HashSet<CtClass>();
        List<String> packageNames = Arrays.asList(packages);
        Path projectPath = Paths.get(projectLocation, new String[0]);
        Path currentPath = Paths.get(projectLocation, packages);
        String packageName = Stream.of(packages).collect(Collectors.joining("."));
        for (File classFile : classFiles = currentPath.toFile().listFiles((dir, name) -> name.endsWith("class"))) {
            String classFileName = classFile.getName();
            String className = classFileName.substring(0, classFileName.length() - ".class".length());
            try {
                CtClass clazz = ClassPool.getDefault().getCtClass(packageName + '.' + className);
                classes.add(clazz);
            }
            catch (NotFoundException e) {
                LogProvider.getLogger().accept("Class " + className + " could not be loaded");
            }
        }
        for (File directory : directories = currentPath.toFile().listFiles((dir, name) -> Paths.get(dir + "/" + name, new String[0]).toFile().isDirectory())) {
            ArrayList<String> newPackageNames = new ArrayList<String>();
            newPackageNames.addAll(packageNames);
            newPackageNames.add(directory.getName());
            classes.addAll(ProjectAnalyzer.getClasses(projectPath.toString(), newPackageNames.toArray(new String[newPackageNames.size()])));
        }
        return classes;
    }
}

