/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.collection;

import com.sebastian_daschner.jaxrs_analyzer.model.instructions.GetFieldInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.GetStaticInstruction;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.SignatureAttribute;

class FieldInstructionBuilder {
    private final CodeIterator codeIterator;
    private final ConstPool pool;

    FieldInstructionBuilder(CodeIterator codeIterator, ConstPool pool) {
        this.codeIterator = codeIterator;
        this.pool = pool;
    }

    GetFieldInstruction buildGetField(int position) throws BadBytecode {
        int index = this.codeIterator.u16bitAt(position + 1);
        String className = this.pool.getFieldrefClassName(index);
        String fieldName = this.pool.getFieldrefName(index);
        String fieldType = this.getFieldType(this.pool.getFieldrefType(index));
        return new GetFieldInstruction(className, fieldName, fieldType);
    }

    GetStaticInstruction buildGetStatic(int position) throws BadBytecode {
        int index = this.codeIterator.u16bitAt(position + 1);
        String className = this.pool.getFieldrefClassName(index);
        String fieldName = this.pool.getFieldrefName(index);
        String fieldType = this.getFieldType(this.pool.getFieldrefType(index));
        return new GetStaticInstruction(className, fieldName, fieldType);
    }

    private String getFieldType(String sigFieldType) throws BadBytecode {
        SignatureAttribute.Type type = SignatureAttribute.toTypeSignature(sigFieldType);
        return type.toString();
    }
}

