/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.collection;

import com.sebastian_daschner.jaxrs_analyzer.model.instructions.PushInstruction;
import javassist.bytecode.ConstPool;

class LdcPushInstructionBuilder {
    private final ConstPool pool;

    LdcPushInstructionBuilder(ConstPool pool) {
        this.pool = pool;
    }

    PushInstruction build(int index) {
        return new PushInstruction(this.getLdc(index));
    }

    private Object getLdc(int index) {
        int tag = this.pool.getTag(index);
        switch (tag) {
            case 8: {
                return this.pool.getStringInfo(index);
            }
            case 3: {
                return this.pool.getIntegerInfo(index);
            }
            case 4: {
                return Float.valueOf(this.pool.getFloatInfo(index));
            }
            case 5: {
                return this.pool.getLongInfo(index);
            }
            case 6: {
                return this.pool.getDoubleInfo(index);
            }
            case 7: {
                return this.pool.getClassInfo(index);
            }
        }
        throw new IllegalStateException("Unknown LDC instruction.");
    }
}

