/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.collection;

import com.sebastian_daschner.jaxrs_analyzer.model.instructions.LoadInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.StoreInstruction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.LocalVariableTypeAttribute;
import javassist.bytecode.SignatureAttribute;

class LoadStoreInstructionBuilder {
    private static final String UNKNOWN_VARIABLE_NAME_PREFIX = "variable$";
    private final Map<Integer, String> variableNames;
    private final Map<Integer, String> variableTypes;

    LoadStoreInstructionBuilder(CodeAttribute codeAttribute) {
        LocalVariableAttribute localVariableAttribute = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
        LocalVariableTypeAttribute localVariableTypeAttribute = (LocalVariableTypeAttribute)codeAttribute.getAttribute("LocalVariableTypeTable");
        this.variableNames = this.buildVariableNames(localVariableAttribute);
        this.variableTypes = this.buildVariableTypes(localVariableAttribute, localVariableTypeAttribute);
    }

    private Map<Integer, String> buildVariableNames(LocalVariableAttribute variableAttribute) {
        if (variableAttribute == null) {
            return Collections.emptyMap();
        }
        return IntStream.range(0, variableAttribute.tableLength()).collect(HashMap::new, (m, i) -> m.put(variableAttribute.index(i), variableAttribute.variableName(i)), Map::putAll);
    }

    private Map<Integer, String> buildVariableTypes(LocalVariableAttribute variableAttribute, LocalVariableTypeAttribute variableTypeAttribute) {
        HashMap<Integer, String> types = new HashMap<Integer, String>();
        if (variableAttribute != null) {
            IntStream.range(0, variableAttribute.tableLength()).forEach(i -> types.put(variableAttribute.index(i), this.getType(variableAttribute, i)));
        }
        if (variableTypeAttribute != null) {
            IntStream.range(0, variableTypeAttribute.tableLength()).forEach(i -> types.put(variableTypeAttribute.index(i), this.getType(variableTypeAttribute, i)));
        }
        return types;
    }

    private String getType(LocalVariableAttribute variableAttribute, int index) {
        String signature = variableAttribute.signature(index);
        try {
            return SignatureAttribute.toTypeSignature(signature).toString();
        }
        catch (BadBytecode e) {
            throw new IllegalStateException("Could not analyze bytecode", e);
        }
    }

    LoadInstruction buildLoad(int index) {
        String type = this.variableTypes.getOrDefault(index, Object.class.getCanonicalName());
        String name = this.variableNames.getOrDefault(index, UNKNOWN_VARIABLE_NAME_PREFIX + index);
        return new LoadInstruction(index, type, name);
    }

    StoreInstruction buildStore(int index) {
        String type = this.variableTypes.getOrDefault(index, Object.class.getCanonicalName());
        String name = this.variableNames.getOrDefault(index, UNKNOWN_VARIABLE_NAME_PREFIX + index);
        return new StoreInstruction(index, type, name);
    }
}

